/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.rest;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.rest.DummyRestConsumerFactory;
import org.apache.camel.impl.JndiRegistry;
import org.apache.camel.model.RouteDefinition;

public class FromRestGetInterceptTest
extends ContextTestSupport {
    @Override
    protected JndiRegistry createRegistry() throws Exception {
        JndiRegistry jndi = super.createRegistry();
        jndi.bind("dummy-rest", (Object)new DummyRestConsumerFactory());
        return jndi;
    }

    public void testFromRestModel() throws Exception {
        this.getMockEndpoint("mock:hello").expectedMessageCount(1);
        this.getMockEndpoint("mock:bar").expectedMessageCount(1);
        this.getMockEndpoint("mock:intercept").expectedMessageCount(4);
        String out = (String)this.template.requestBody("seda:get-say-hello", (Object)"I was here", String.class);
        FromRestGetInterceptTest.assertEquals((String)"Bye World", (String)out);
        this.assertMockEndpointsSatisfied();
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                this.intercept().to("mock:intercept");
                ((RouteDefinition)((RouteDefinition)this.rest("/say/hello").get().route().to("mock:hello")).to("mock:bar")).transform().constant((Object)"Bye World");
            }
        };
    }
}

