/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.seda;

import org.apache.camel.CamelExecutionException;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.ResolveEndpointFailedException;
import org.apache.camel.builder.RouteBuilder;

public class SameSedaQueueSizeAndNoSizeTest
extends ContextTestSupport {
    public void testSameQueue() throws Exception {
        block3: {
            for (int i = 0; i < 100; ++i) {
                this.template.sendBody("seda:foo", (Object)("" + i));
            }
            try {
                this.template.sendBody("seda:foo", (Object)"Should be full now");
                SameSedaQueueSizeAndNoSizeTest.fail((String)"Should fail");
            }
            catch (CamelExecutionException e) {
                IllegalStateException ise = SameSedaQueueSizeAndNoSizeTest.assertIsInstanceOf(IllegalStateException.class, e.getCause());
                if (SameSedaQueueSizeAndNoSizeTest.isJavaVendor("ibm")) break block3;
                SameSedaQueueSizeAndNoSizeTest.assertEquals((String)"Queue full", (String)ise.getMessage());
            }
        }
    }

    public void testSameQueueDifferentSize() throws Exception {
        try {
            this.template.sendBody("seda:foo?size=200", (Object)"Should fail");
            SameSedaQueueSizeAndNoSizeTest.fail((String)"Should fail");
        }
        catch (ResolveEndpointFailedException e) {
            IllegalArgumentException ise = SameSedaQueueSizeAndNoSizeTest.assertIsInstanceOf(IllegalArgumentException.class, e.getCause());
            SameSedaQueueSizeAndNoSizeTest.assertEquals((String)"Cannot use existing queue seda://foo as the existing queue size 100 does not match given queue size 200", (String)ise.getMessage());
        }
    }

    public void testSameQueueDifferentSizeBar() throws Exception {
        try {
            this.template.sendBody("seda:bar?size=200", (Object)"Should fail");
            SameSedaQueueSizeAndNoSizeTest.fail((String)"Should fail");
        }
        catch (ResolveEndpointFailedException e) {
            IllegalArgumentException ise = SameSedaQueueSizeAndNoSizeTest.assertIsInstanceOf(IllegalArgumentException.class, e.getCause());
            SameSedaQueueSizeAndNoSizeTest.assertEquals((String)"Cannot use existing queue seda://bar as the existing queue size 2147483647 does not match given queue size 200", (String)ise.getMessage());
        }
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                this.from("seda:foo?size=100").routeId("foo").noAutoStartup().to("mock:foo");
                this.from("seda:bar").routeId("bar").noAutoStartup().to("mock:bar");
            }
        };
    }
}

