/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.seda;

import java.util.concurrent.Future;
import org.apache.camel.CamelContext;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.ExchangePattern;
import org.apache.camel.Processor;
import org.apache.camel.WaitForTaskToComplete;
import org.apache.camel.builder.ErrorHandlerBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.impl.DefaultExchange;
import org.apache.camel.model.ExpressionNode;

public class SedaAsyncProducerTest
extends ContextTestSupport {
    private String route = "";

    public void testAsyncProducer() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedMessageCount(1);
        Future future = this.template.asyncRequestBody("direct:start", (Object)"Hello World", String.class);
        this.route = this.route + "send";
        this.assertMockEndpointsSatisfied();
        SedaAsyncProducerTest.assertEquals((String)"Send should occur before processor", (String)"sendprocess", (String)this.route);
        String response = (String)future.get();
        SedaAsyncProducerTest.assertEquals((String)"Bye World", (String)response);
    }

    public void testAsyncProducerWait() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedMessageCount(1);
        DefaultExchange exchange = new DefaultExchange((CamelContext)this.context);
        exchange.getIn().setBody((Object)"Hello World");
        exchange.setPattern(ExchangePattern.InOut);
        exchange.setProperty("CamelAsyncWait", (Object)WaitForTaskToComplete.IfReplyExpected);
        this.template.send("direct:start", (Exchange)exchange);
        this.route = this.route + "send";
        this.assertMockEndpointsSatisfied();
        SedaAsyncProducerTest.assertEquals((String)"Send should occur before processor", (String)"processsend", (String)this.route);
        String response = (String)exchange.getOut().getBody(String.class);
        SedaAsyncProducerTest.assertEquals((String)"Bye World", (String)response);
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                this.errorHandler((ErrorHandlerBuilder)this.noErrorHandler());
                ((ExpressionNode)this.from("direct:start").delay(100L).process(new Processor(){

                    public void process(Exchange exchange) throws Exception {
                        SedaAsyncProducerTest.this.route = SedaAsyncProducerTest.this.route + "process";
                        exchange.getOut().setBody((Object)"Bye World");
                    }
                })).to("mock:result");
            }
        };
    }
}

