/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.seda;

import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import org.apache.camel.CamelContext;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.seda.SedaComponent;
import org.apache.camel.component.seda.SedaConsumer;
import org.apache.camel.component.seda.SedaEndpoint;
import org.apache.camel.component.seda.SedaProducer;

public class SedaEndpointTest
extends ContextTestSupport {
    private BlockingQueue<Exchange> queue = new ArrayBlockingQueue<Exchange>(1000);

    public void testSedaEndpointUnboundedQueue() throws Exception {
        LinkedBlockingQueue unbounded = new LinkedBlockingQueue();
        SedaEndpoint seda = new SedaEndpoint("seda://foo", this.context.getComponent("seda"), unbounded);
        SedaEndpointTest.assertNotNull((Object)seda);
        SedaEndpointTest.assertEquals((int)Integer.MAX_VALUE, (int)seda.getSize());
        SedaEndpointTest.assertSame(unbounded, (Object)seda.getQueue());
        SedaEndpointTest.assertEquals((int)1, (int)seda.getConcurrentConsumers());
        Producer prod = seda.createProducer();
        seda.onStarted((SedaProducer)prod);
        SedaEndpointTest.assertEquals((int)1, (int)seda.getProducers().size());
        Consumer cons = seda.createConsumer(new Processor(){

            public void process(Exchange exchange) throws Exception {
            }
        });
        seda.onStarted((SedaConsumer)cons);
        SedaEndpointTest.assertEquals((int)1, (int)seda.getConsumers().size());
        SedaEndpointTest.assertEquals((int)0, (int)seda.getExchanges().size());
    }

    public void testSedaEndpoint() throws Exception {
        SedaEndpoint seda = new SedaEndpoint("seda://foo", this.context.getComponent("seda"), this.queue);
        SedaEndpointTest.assertNotNull((Object)seda);
        SedaEndpointTest.assertEquals((int)1000, (int)seda.getSize());
        SedaEndpointTest.assertSame(this.queue, (Object)seda.getQueue());
        SedaEndpointTest.assertEquals((int)1, (int)seda.getConcurrentConsumers());
        Producer prod = seda.createProducer();
        seda.onStarted((SedaProducer)prod);
        SedaEndpointTest.assertEquals((int)1, (int)seda.getProducers().size());
        Consumer cons = seda.createConsumer(new Processor(){

            public void process(Exchange exchange) throws Exception {
            }
        });
        seda.onStarted((SedaConsumer)cons);
        SedaEndpointTest.assertEquals((int)1, (int)seda.getConsumers().size());
        SedaEndpointTest.assertEquals((int)0, (int)seda.getExchanges().size());
    }

    public void testSedaEndpointTwo() throws Exception {
        SedaEndpoint seda = new SedaEndpoint("seda://foo", this.context.getComponent("seda"), this.queue, 2);
        SedaEndpointTest.assertNotNull((Object)seda);
        SedaEndpointTest.assertEquals((int)1000, (int)seda.getSize());
        SedaEndpointTest.assertSame(this.queue, (Object)seda.getQueue());
        SedaEndpointTest.assertEquals((int)2, (int)seda.getConcurrentConsumers());
        Producer prod = seda.createProducer();
        seda.onStarted((SedaProducer)prod);
        SedaEndpointTest.assertEquals((int)1, (int)seda.getProducers().size());
        Consumer cons = seda.createConsumer(new Processor(){

            public void process(Exchange exchange) throws Exception {
            }
        });
        seda.onStarted((SedaConsumer)cons);
        SedaEndpointTest.assertEquals((int)1, (int)seda.getConsumers().size());
        SedaEndpointTest.assertEquals((int)0, (int)seda.getExchanges().size());
    }

    public void testSedaEndpointSetQueue() throws Exception {
        SedaEndpoint seda = new SedaEndpoint();
        SedaEndpointTest.assertNotNull((Object)seda);
        seda.setCamelContext((CamelContext)this.context);
        seda.setEndpointUriIfNotSpecified("seda://bar");
        SedaEndpointTest.assertNotNull((Object)seda.getQueue());
        seda.setQueue(new ArrayBlockingQueue(1000));
        seda.setConcurrentConsumers(2);
        SedaEndpointTest.assertEquals((int)1000, (int)seda.getSize());
        SedaEndpointTest.assertNotSame(this.queue, (Object)seda.getQueue());
        SedaEndpointTest.assertEquals((int)2, (int)seda.getConcurrentConsumers());
        Producer prod = seda.createProducer();
        seda.onStarted((SedaProducer)prod);
        SedaEndpointTest.assertEquals((int)1, (int)seda.getProducers().size());
        Consumer cons = seda.createConsumer(new Processor(){

            public void process(Exchange exchange) throws Exception {
            }
        });
        seda.onStarted((SedaConsumer)cons);
        SedaEndpointTest.assertEquals((int)1, (int)seda.getConsumers().size());
        SedaEndpointTest.assertEquals((int)0, (int)seda.getExchanges().size());
    }

    public void testSedaConsumer() throws Exception {
        SedaEndpoint seda = (SedaEndpoint)this.context.getEndpoint("seda://foo", SedaEndpoint.class);
        Consumer consumer = seda.createConsumer(new Processor(){

            public void process(Exchange exchange) throws Exception {
            }
        });
        SedaEndpointTest.assertSame((Object)seda, (Object)consumer.getEndpoint());
        SedaEndpointTest.assertNotNull((Object)consumer.toString());
    }

    public void testSedaDefaultValue() throws Exception {
        SedaComponent sedaComponent = new SedaComponent();
        sedaComponent.setQueueSize(300);
        sedaComponent.setConcurrentConsumers(3);
        this.context.addComponent("seda", (Component)sedaComponent);
        SedaEndpoint seda = (SedaEndpoint)this.context.getEndpoint("seda://foo", SedaEndpoint.class);
        SedaEndpointTest.assertEquals((int)300, (int)seda.getSize());
        SedaEndpointTest.assertEquals((int)3, (int)seda.getConcurrentConsumers());
    }
}

