/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.seda;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;

public class SedaRemoveRouteThenAddAgainTest
extends ContextTestSupport {
    public void testRemoveRouteAndThenAddAgain() throws Exception {
        MockEndpoint out = this.getMockEndpoint("mock:out");
        out.expectedMessageCount(1);
        out.expectedBodiesReceived(new Object[]{"before removing the route"});
        this.template.sendBody("seda:in", (Object)"before removing the route");
        out.assertIsSatisfied();
        this.context.stopRoute("sedaToMock");
        this.context.removeRoute("sedaToMock");
        this.context.addRoutes((RoutesBuilder)this.createRouteBuilder());
        out = this.getMockEndpoint("mock:out");
        out.expectedMessageCount(1);
        out.expectedBodiesReceived(new Object[]{"after removing the route"});
        this.template.sendBody("seda:in", (Object)"after removing the route");
        out.assertIsSatisfied();
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                this.from("seda:in").routeId("sedaToMock").to("mock:out");
            }
        };
    }
}

