/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.test;

import org.apache.camel.ComponentConfiguration;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.EndpointConfiguration;
import org.apache.camel.component.test.TestComponent;
import org.apache.camel.impl.DefaultCamelContext;
import org.junit.Test;

public class TestComponentConfigurationAndDocumentationTest
extends ContextTestSupport {
    @Override
    public boolean isUseRouteBuilder() {
        return false;
    }

    @Test
    public void testComponentConfiguration() throws Exception {
        TestComponent comp = (TestComponent)this.context.getComponent("test", TestComponent.class);
        EndpointConfiguration conf = comp.createConfiguration("test:my:foo?timeout=1000");
        TestComponentConfigurationAndDocumentationTest.assertEquals((Object)"1000", (Object)conf.getParameter("timeout"));
        ComponentConfiguration compConf = comp.createComponentConfiguration();
        String json = compConf.createParameterJsonSchema();
        TestComponentConfigurationAndDocumentationTest.assertNotNull((Object)json);
        TestComponentConfigurationAndDocumentationTest.assertTrue((boolean)json.contains("\"retainFirst\": { \"kind\": \"parameter\", \"type\": \"integer\""));
        TestComponentConfigurationAndDocumentationTest.assertTrue((boolean)json.contains("\"timeout\": { \"kind\": \"parameter\", \"type\": \"integer\""));
    }

    @Test
    public void testComponentDocumentation() throws Exception {
        DefaultCamelContext context = new DefaultCamelContext();
        String html = context.getComponentDocumentation("test");
        TestComponentConfigurationAndDocumentationTest.assertNotNull((String)"Should have found some auto-generated HTML", (Object)html);
    }
}

