/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.vm;

import java.util.Arrays;
import java.util.List;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.component.vm.AbstractVmTestSupport;
import org.apache.camel.impl.JndiRegistry;
import org.apache.camel.model.SplitDefinition;

public class VMSplitterTest
extends AbstractVmTestSupport {
    @Override
    protected JndiRegistry createRegistry() throws Exception {
        JndiRegistry jndi = super.createRegistry();
        jndi.bind("splitterBean", (Object)new SplitWordsBean());
        return jndi;
    }

    public void testSplitUsingMethodCall() throws Exception {
        MockEndpoint resultEndpoint = this.getMockEndpoint("mock:result");
        resultEndpoint.expectedBodiesReceived(new Object[]{"Claus", "James", "Willem"});
        this.template2.sendBody("direct:start", (Object)"Claus@James@Willem");
        this.assertMockEndpointsSatisfied();
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                ((SplitDefinition)this.from("vm:server").split().method("splitterBean", "splitWords")).to("mock:result");
            }
        };
    }

    @Override
    protected RouteBuilder createRouteBuilderForSecondContext() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                this.from("direct:start").to("vm:server");
            }
        };
    }

    public static final class SplitWordsBean {
        private SplitWordsBean() {
        }

        public static List<String> splitWords(String body) {
            return Arrays.asList(body.split("@"));
        }
    }
}

