/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.vm;

import java.util.Iterator;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.seda.QueueReference;
import org.apache.camel.component.vm.VmComponent;

public class VmComponentReferenceEndpointTest
extends ContextTestSupport {
    public void testVmComponentReference() throws Exception {
        VmComponent vm = (VmComponent)this.context.getComponent("vm", VmComponent.class);
        String key = vm.getQueueKey("vm://foo");
        VmComponentReferenceEndpointTest.assertEquals((int)1, (int)((QueueReference)vm.getQueues().get(key)).getCount());
        VmComponentReferenceEndpointTest.assertEquals((int)2, (int)this.numberOfReferences(vm));
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() throws Exception {
                this.from("vm:foo?blockWhenFull=true").routeId("foo2").to("mock:foo2");
            }
        });
        VmComponentReferenceEndpointTest.assertEquals((int)2, (int)((QueueReference)vm.getQueues().get(key)).getCount());
        VmComponentReferenceEndpointTest.assertEquals((int)3, (int)this.numberOfReferences(vm));
        this.context.stopRoute("foo");
        this.context.removeRoute("foo");
        VmComponentReferenceEndpointTest.assertEquals((int)1, (int)((QueueReference)vm.getQueues().get(key)).getCount());
        VmComponentReferenceEndpointTest.assertEquals((int)2, (int)this.numberOfReferences(vm));
        this.context.stopRoute("foo2");
        this.context.removeRoute("foo2");
        VmComponentReferenceEndpointTest.assertNull(vm.getQueues().get(key));
        VmComponentReferenceEndpointTest.assertEquals((int)1, (int)this.numberOfReferences(vm));
        key = vm.getQueueKey("vm://bar");
        VmComponentReferenceEndpointTest.assertEquals((int)1, (int)((QueueReference)vm.getQueues().get(key)).getCount());
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                this.from("vm:foo").routeId("foo").to("mock:foo");
                this.from("vm:bar").routeId("bar").to("mock:bar");
            }
        };
    }

    private int numberOfReferences(VmComponent vm) {
        int num = 0;
        Iterator it = vm.getQueues().values().iterator();
        while (it.hasNext()) {
            num += ((QueueReference)it.next()).getCount();
        }
        return num;
    }
}

