/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.vm;

import org.apache.camel.Exchange;
import org.apache.camel.ExchangePattern;
import org.apache.camel.Expression;
import org.apache.camel.Processor;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.vm.AbstractVmTestSupport;
import org.apache.camel.model.RouteDefinition;

public class VmWaitForTaskCompleteTest
extends AbstractVmTestSupport {
    public void testInOut() throws Exception {
        this.getMockEndpoint("mock:result").expectedBodiesReceived(new Object[]{"Bye World"});
        String out = (String)this.template2.requestBody("direct:start", (Object)"Hello World", String.class);
        VmWaitForTaskCompleteTest.assertEquals((String)"Bye World", (String)out);
        this.assertMockEndpointsSatisfied();
    }

    public void testInOnly() throws Exception {
        this.getMockEndpoint("mock:result").expectedBodiesReceived(new Object[]{"Bye World"});
        Exchange out = this.template2.send("direct:start", new Processor(){

            public void process(Exchange exchange) throws Exception {
                exchange.getIn().setBody((Object)"Hello World");
                exchange.setPattern(ExchangePattern.InOnly);
            }
        });
        VmWaitForTaskCompleteTest.assertEquals((Object)"Bye World", (Object)out.getIn().getBody());
        this.assertMockEndpointsSatisfied();
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                ((RouteDefinition)this.from("vm:foo?waitForTaskToComplete=Always").transform((Expression)this.constant("Bye World"))).to("mock:result");
            }
        };
    }

    @Override
    protected RouteBuilder createRouteBuilderForSecondContext() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                this.from("direct:start").to("vm:foo?waitForTaskToComplete=Always");
            }
        };
    }
}

