/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.converter;

import java.sql.Timestamp;
import java.util.concurrent.Future;
import org.apache.camel.CamelContext;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.NoTypeConversionAvailableException;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.impl.DefaultExchange;

public class FutureConverterTest
extends ContextTestSupport {
    public void testConvertFuture() {
        Future future = this.template.asyncRequestBody("direct:foo", (Object)"Hello World");
        String out = (String)this.context.getTypeConverter().convertTo(String.class, (Object)future);
        FutureConverterTest.assertEquals((String)"Bye World", (String)out);
    }

    public void testConvertMandatoryFuture() throws Exception {
        Future future = this.template.asyncRequestBody("direct:foo", (Object)"Hello World");
        String out = (String)this.context.getTypeConverter().mandatoryConvertTo(String.class, (Object)future);
        FutureConverterTest.assertEquals((String)"Bye World", (String)out);
    }

    public void testConvertMandatoryFutureWithExchange() throws Exception {
        DefaultExchange exchange = new DefaultExchange((CamelContext)this.context);
        Future future = this.template.asyncRequestBody("direct:foo", (Object)"Hello World");
        String out = (String)this.context.getTypeConverter().mandatoryConvertTo(String.class, (Exchange)exchange, (Object)future);
        FutureConverterTest.assertEquals((String)"Bye World", (String)out);
    }

    public void testConvertMandatoryFutureWithExchangeFailed() throws Exception {
        DefaultExchange exchange = new DefaultExchange((CamelContext)this.context);
        Future future = this.template.asyncRequestBody("direct:foo", (Object)"Hello World");
        try {
            this.context.getTypeConverter().mandatoryConvertTo(Timestamp.class, (Exchange)exchange, (Object)future);
            FutureConverterTest.fail((String)"Should have thrown an exception");
        }
        catch (NoTypeConversionAvailableException noTypeConversionAvailableException) {
            // empty catch block
        }
    }

    public void testConvertFutureWithExchangeFailed() throws Exception {
        DefaultExchange exchange = new DefaultExchange((CamelContext)this.context);
        Future future = this.template.asyncRequestBody("direct:foo", (Object)"Hello World");
        Timestamp out = (Timestamp)this.context.getTypeConverter().convertTo(Timestamp.class, (Exchange)exchange, (Object)future);
        FutureConverterTest.assertNull((Object)out);
    }

    public void testConvertFutureCancelled() {
        Future future = this.template.asyncRequestBody("direct:foo", (Object)"Hello World");
        future.cancel(true);
        Object out = this.context.getTypeConverter().convertTo(String.class, (Object)future);
        FutureConverterTest.assertNull((Object)out);
    }

    public void testConvertFutureCancelledThenOkay() {
        Future future = this.template.asyncRequestBody("direct:foo", (Object)"Hello World");
        future.cancel(true);
        Object out = this.context.getTypeConverter().convertTo(String.class, (Object)future);
        FutureConverterTest.assertNull((Object)out);
        future = this.template.asyncRequestBody("direct:foo", (Object)"Hello World");
        out = this.context.getTypeConverter().convertTo(String.class, (Object)future);
        FutureConverterTest.assertEquals((Object)"Bye World", (Object)out);
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                this.from("direct:foo").delay(500L).transform((Expression)this.constant("Bye World"));
            }
        };
    }
}

