/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.converter;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Field;
import java.nio.charset.Charset;
import java.util.Arrays;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.converter.IOConverter;

public class IOConverterCharsetTest
extends ContextTestSupport {
    private static final String CONTENT = "G\u00f6tzend\u00e4mmerung,Joseph und seine Br\u00fcder";
    private static final Charset DEFAULT_CHARSET = Charset.defaultCharset();

    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
        this.switchToDefaultCharset(DEFAULT_CHARSET.displayName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testToInputStreamFileWithCharsetUTF8() throws Exception {
        this.switchToDefaultCharset("UTF-8");
        File file = new File("src/test/resources/org/apache/camel/converter/german.utf-8.txt");
        InputStream in = IOConverter.toInputStream((File)file, (String)"UTF-8");
        BufferedReader reader = new BufferedReader(new InputStreamReader(in));
        BufferedReader naiveReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), "UTF-8"));
        try {
            String line = reader.readLine();
            String naiveLine = naiveReader.readLine();
            IOConverterCharsetTest.assertEquals((String)naiveLine, (String)line);
            IOConverterCharsetTest.assertEquals((String)CONTENT, (String)line);
        }
        finally {
            reader.close();
            naiveReader.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testToInputStreamFileWithCharsetUTF8withOtherDefaultEncoding() throws Exception {
        this.switchToDefaultCharset("ISO-8859-1");
        File file = new File("src/test/resources/org/apache/camel/converter/german.utf-8.txt");
        InputStream in = IOConverter.toInputStream((File)file, (String)"UTF-8");
        BufferedReader reader = new BufferedReader(new InputStreamReader(in));
        BufferedReader naiveReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), "UTF-8"));
        try {
            String line = reader.readLine();
            String naiveLine = naiveReader.readLine();
            IOConverterCharsetTest.assertEquals((String)naiveLine, (String)line);
            IOConverterCharsetTest.assertEquals((String)CONTENT, (String)line);
        }
        finally {
            reader.close();
            naiveReader.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testToInputStreamFileWithCharsetLatin1() throws Exception {
        this.switchToDefaultCharset("UTF-8");
        File file = new File("src/test/resources/org/apache/camel/converter/german.iso-8859-1.txt");
        InputStream in = IOConverter.toInputStream((File)file, (String)"ISO-8859-1");
        BufferedReader reader = new BufferedReader(new InputStreamReader(in));
        BufferedReader naiveReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), "ISO-8859-1"));
        try {
            String line = reader.readLine();
            String naiveLine = naiveReader.readLine();
            IOConverterCharsetTest.assertEquals((String)naiveLine, (String)line);
            IOConverterCharsetTest.assertEquals((String)CONTENT, (String)line);
        }
        finally {
            reader.close();
            naiveReader.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testToInputStreamFileDirectByteDumpWithCharsetLatin1() throws Exception {
        this.switchToDefaultCharset("UTF-8");
        File file = new File("src/test/resources/org/apache/camel/converter/german.iso-8859-1.txt");
        InputStream in = IOConverter.toInputStream((File)file, (String)"ISO-8859-1");
        FileInputStream naiveIn = new FileInputStream(file);
        try {
            byte[] bytes = new byte[8192];
            in.read(bytes);
            byte[] naiveBytes = new byte[8192];
            ((InputStream)naiveIn).read(naiveBytes);
            IOConverterCharsetTest.assertFalse((String)"both input streams deliver the same byte sequence", (boolean)Arrays.equals(naiveBytes, bytes));
        }
        finally {
            in.close();
            ((InputStream)naiveIn).close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testToReaderFileWithCharsetUTF8() throws Exception {
        File file = new File("src/test/resources/org/apache/camel/converter/german.utf-8.txt");
        BufferedReader reader = IOConverter.toReader((File)file, (String)"UTF-8");
        BufferedReader naiveReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), "UTF-8"));
        try {
            String line = reader.readLine();
            String naiveLine = naiveReader.readLine();
            IOConverterCharsetTest.assertEquals((String)naiveLine, (String)line);
            IOConverterCharsetTest.assertEquals((String)CONTENT, (String)line);
        }
        finally {
            reader.close();
            naiveReader.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testToReaderFileWithCharsetLatin1() throws Exception {
        File file = new File("src/test/resources/org/apache/camel/converter/german.iso-8859-1.txt");
        BufferedReader reader = IOConverter.toReader((File)file, (String)"ISO-8859-1");
        BufferedReader naiveReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), "ISO-8859-1"));
        try {
            String line = reader.readLine();
            String naiveLine = naiveReader.readLine();
            IOConverterCharsetTest.assertEquals((String)naiveLine, (String)line);
            IOConverterCharsetTest.assertEquals((String)CONTENT, (String)line);
        }
        finally {
            reader.close();
            naiveReader.close();
        }
    }

    private void switchToDefaultCharset(String charset) {
        try {
            Field defaultCharset = Charset.class.getDeclaredField("defaultCharset");
            defaultCharset.setAccessible(true);
            defaultCharset.set(null, Charset.forName(charset));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

