/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.converter;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.net.URL;
import java.util.Properties;
import org.apache.camel.CamelContext;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.converter.IOConverter;
import org.apache.camel.impl.DefaultExchange;
import org.apache.camel.util.IOHelper;
import org.apache.camel.util.ObjectHelper;

public class IOConverterTest
extends ContextTestSupport {
    private static final byte[] TESTDATA = "My test data".getBytes();

    public void testToBytes() throws Exception {
        File file = new File("src/test/resources/org/apache/camel/converter/dummy.txt");
        byte[] data = IOConverter.toBytes((InputStream)new FileInputStream(file));
        IOConverterTest.assertEquals((String)"get the wrong byte size", (long)file.length(), (long)data.length);
        IOConverterTest.assertEquals((char)'#', (char)((char)data[0]));
        String s = new String(data);
        IOConverterTest.assertTrue((String)"Should contain Hello World!", (boolean)s.contains("Hello World"));
    }

    public void testCopy() throws Exception {
        ByteArrayInputStream bis = new ByteArrayInputStream(TESTDATA);
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        IOHelper.copy((InputStream)bis, (OutputStream)bos);
        this.assertEquals(TESTDATA, bos.toByteArray());
    }

    private void assertEquals(byte[] data1, byte[] data2) {
        IOConverterTest.assertEquals((int)data1.length, (int)data2.length);
        for (int i = 0; i < data1.length; ++i) {
            IOConverterTest.assertEquals((byte)data1[i], (byte)data2[i]);
        }
    }

    public void testToOutputStreamFile() throws Exception {
        this.template.sendBodyAndHeader("file://target/test", (Object)"Hello World", "CamelFileName", (Object)"hello.txt");
        File file = new File("target/test/hello.txt");
        OutputStream os = IOConverter.toOutputStream((File)file);
        IOConverterTest.assertIsInstanceOf(BufferedOutputStream.class, os);
        os.close();
    }

    public void testToWriterFile() throws Exception {
        this.template.sendBodyAndHeader("file://target/test", (Object)"Hello World", "CamelFileName", (Object)"hello.txt");
        File file = new File("target/test/hello.txt");
        BufferedWriter writer = IOConverter.toWriter((File)file, null);
        IOConverterTest.assertIsInstanceOf(BufferedWriter.class, writer);
        ((Writer)writer).close();
    }

    public void testToReader() throws Exception {
        StringReader reader = IOConverter.toReader((String)"Hello");
        IOConverterTest.assertEquals((String)"Hello", (String)IOConverter.toString((Reader)reader));
    }

    public void testToInputStreamExchange() throws Exception {
        DefaultExchange exchange = new DefaultExchange((CamelContext)this.context);
        exchange.setProperty("CamelCharsetName", (Object)ObjectHelper.getDefaultCharacterSet());
        InputStream is = IOConverter.toInputStream((String)"Hello World", (Exchange)exchange);
        IOConverterTest.assertNotNull((Object)is);
        IOConverterTest.assertEquals((String)"Hello World", (String)IOConverter.toString((InputStream)is, (Exchange)exchange));
    }

    public void testToInputStreamStringBufferAndBuilderExchange() throws Exception {
        DefaultExchange exchange = new DefaultExchange((CamelContext)this.context);
        exchange.setProperty("CamelCharsetName", (Object)ObjectHelper.getDefaultCharacterSet());
        StringBuffer buffer = new StringBuffer();
        buffer.append("Hello World");
        InputStream is = IOConverter.toInputStream((StringBuffer)buffer, (Exchange)exchange);
        IOConverterTest.assertNotNull((Object)is);
        IOConverterTest.assertEquals((String)"Hello World", (String)IOConverter.toString((InputStream)is, (Exchange)exchange));
        StringBuilder builder = new StringBuilder();
        builder.append("Hello World");
        is = IOConverter.toInputStream((StringBuilder)builder, (Exchange)exchange);
        IOConverterTest.assertNotNull((Object)is);
        IOConverterTest.assertEquals((String)"Hello World", (String)IOConverter.toString((InputStream)is, (Exchange)exchange));
    }

    public void testToInputStreamBufferReader() throws Exception {
        DefaultExchange exchange = new DefaultExchange((CamelContext)this.context);
        exchange.setProperty("CamelCharsetName", (Object)ObjectHelper.getDefaultCharacterSet());
        BufferedReader br = IOHelper.buffered((Reader)new StringReader("Hello World"));
        InputStream is = IOConverter.toInputStream((BufferedReader)br, (Exchange)exchange);
        IOConverterTest.assertNotNull((Object)is);
    }

    public void testToByteArrayFile() throws Exception {
        this.template.sendBodyAndHeader("file://target/test", (Object)"Hello World", "CamelFileName", (Object)"hello.txt");
        File file = new File("target/test/hello.txt");
        byte[] data = IOConverter.toByteArray((File)file);
        IOConverterTest.assertNotNull((Object)data);
        IOConverterTest.assertEquals((int)11, (int)data.length);
    }

    public void testToStringBufferReader() throws Exception {
        BufferedReader br = IOHelper.buffered((Reader)new StringReader("Hello World"));
        String s = IOConverter.toString((BufferedReader)br);
        IOConverterTest.assertNotNull((Object)s);
        IOConverterTest.assertEquals((String)"Hello World", (String)s);
    }

    public void testToByteArrayBufferReader() throws Exception {
        BufferedReader br = IOHelper.buffered((Reader)new StringReader("Hello World"));
        byte[] bytes = IOConverter.toByteArray((BufferedReader)br, null);
        IOConverterTest.assertNotNull((Object)bytes);
        IOConverterTest.assertEquals((int)11, (int)bytes.length);
    }

    public void testToByteArrayReader() throws Exception {
        BufferedReader br = IOHelper.buffered((Reader)new StringReader("Hello World"));
        byte[] bytes = IOConverter.toByteArray((Reader)br, null);
        IOConverterTest.assertNotNull((Object)bytes);
        IOConverterTest.assertEquals((int)11, (int)bytes.length);
    }

    public void testToByteArrayOutputStream() throws Exception {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        os.write("Hello World".getBytes());
        byte[] bytes = IOConverter.toByteArray((ByteArrayOutputStream)os);
        IOConverterTest.assertNotNull((Object)bytes);
        IOConverterTest.assertEquals((int)11, (int)bytes.length);
    }

    public void testToStringOutputStream() throws Exception {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        os.write("Hello World".getBytes());
        String s = IOConverter.toString((ByteArrayOutputStream)os, null);
        IOConverterTest.assertNotNull((Object)s);
        IOConverterTest.assertEquals((String)"Hello World", (String)s);
    }

    public void testToInputStreamOutputStream() throws Exception {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        os.write("Hello World".getBytes());
        InputStream is = IOConverter.toInputStream((ByteArrayOutputStream)os);
        IOConverterTest.assertNotNull((Object)is);
        IOConverterTest.assertEquals((String)"Hello World", (String)IOConverter.toString((InputStream)is, null));
    }

    public void testToInputStreamUrl() throws Exception {
        URL url = ObjectHelper.loadResourceAsURL((String)"log4j.properties");
        InputStream is = IOConverter.toInputStream((URL)url);
        IOConverterTest.assertIsInstanceOf(BufferedInputStream.class, is);
    }

    public void testStringUrl() throws Exception {
        URL url = ObjectHelper.loadResourceAsURL((String)"log4j.properties");
        String s = IOConverter.toString((URL)url, null);
        IOConverterTest.assertNotNull((Object)s);
    }

    public void testStringByBufferedReader() throws Exception {
        BufferedReader br = IOHelper.buffered((Reader)new StringReader("Hello World"));
        IOConverterTest.assertEquals((String)"Hello World", (String)IOConverter.toString((BufferedReader)br));
    }

    public void testByteArrayByBufferedReader() throws Exception {
        StringReader reader = new StringReader("Hello World");
        byte[] data = IOConverter.toByteArray((Reader)reader, null);
        IOConverterTest.assertNotNull((Object)data);
        IOConverterTest.assertEquals((String)"Hello World", (String)((String)this.context.getTypeConverter().convertTo(String.class, (Object)data)));
    }

    public void testInputStreamToString() throws Exception {
        String data = "46\u00b037'00\"N\"";
        ByteArrayInputStream is = new ByteArrayInputStream(data.getBytes("UTF-8"));
        DefaultExchange exchange = new DefaultExchange((CamelContext)this.context);
        exchange.setProperty("CamelCharsetName", (Object)"UTF-8");
        String result = IOConverter.toString((InputStream)is, (Exchange)exchange);
        IOConverterTest.assertEquals((String)"Get a wrong result", (String)data, (String)result);
    }

    public void testToPropertiesFromReader() throws Exception {
        BufferedReader br = IOHelper.buffered((Reader)new StringReader("foo=123\nbar=456"));
        Properties p = IOConverter.toProperties((Reader)br);
        IOConverterTest.assertNotNull((Object)p);
        IOConverterTest.assertEquals((int)2, (int)p.size());
        IOConverterTest.assertEquals((Object)"123", (Object)p.get("foo"));
        IOConverterTest.assertEquals((Object)"456", (Object)p.get("bar"));
    }

    public void testToPropertiesFromFile() throws Exception {
        Properties p = IOConverter.toProperties((File)new File("src/test/resources/log4j.properties"));
        IOConverterTest.assertNotNull((Object)p);
        IOConverterTest.assertTrue((String)("Should be 8 or more properties, was " + p.size()), (p.size() >= 8 ? 1 : 0) != 0);
        String root = (String)p.get("log4j.rootLogger");
        IOConverterTest.assertNotNull((Object)root);
        IOConverterTest.assertTrue((boolean)root.contains("INFO"));
    }
}

