/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.converter;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.converter.TimePatternConverter;

public class TimePatternConverterTest
extends ContextTestSupport {
    public void testMillisecondsTimePattern() throws Exception {
        String source = new String("444");
        long milliseconds = TimePatternConverter.toMilliSeconds((String)source);
        TimePatternConverterTest.assertEquals((long)444L, (long)milliseconds);
    }

    public void testMilliseconds2TimePattern() throws Exception {
        String source = new String("-72");
        long milliseconds = TimePatternConverter.toMilliSeconds((String)source);
        TimePatternConverterTest.assertEquals((long)-72L, (long)milliseconds);
    }

    public void testSTimePattern() throws Exception {
        String source = new String("35s");
        long milliseconds = TimePatternConverter.toMilliSeconds((String)source);
        TimePatternConverterTest.assertEquals((long)35000L, (long)milliseconds);
    }

    public void testConsiderLegalSTimePattern() throws Exception {
        String source = new String("89s");
        long milliseconds = TimePatternConverter.toMilliSeconds((String)source);
        TimePatternConverterTest.assertEquals((long)89000L, (long)milliseconds);
    }

    public void testMTimePattern() throws Exception {
        String source = new String("28m");
        long milliseconds = TimePatternConverter.toMilliSeconds((String)source);
        TimePatternConverterTest.assertEquals((long)1680000L, (long)milliseconds);
    }

    public void testConsiderLegalMTimePattern() throws Exception {
        String source = new String("89m");
        long milliseconds = TimePatternConverter.toMilliSeconds((String)source);
        TimePatternConverterTest.assertEquals((long)5340000L, (long)milliseconds);
    }

    public void testHMSTimePattern() throws Exception {
        String source = new String("1h3m5s");
        long milliseconds = TimePatternConverter.toMilliSeconds((String)source);
        TimePatternConverterTest.assertEquals((long)3785000L, (long)milliseconds);
    }

    public void testHMSTimePattern2() throws Exception {
        String source = new String("1hours30minutes1second");
        long milliseconds = TimePatternConverter.toMilliSeconds((String)source);
        TimePatternConverterTest.assertEquals((long)5401000L, (long)milliseconds);
    }

    public void testHMSTimePattern3() throws Exception {
        String source = new String("1HOUR3m5s");
        long milliseconds = TimePatternConverter.toMilliSeconds((String)source);
        TimePatternConverterTest.assertEquals((long)3785000L, (long)milliseconds);
    }

    public void testMSTimePattern() throws Exception {
        String source = new String("30m55s");
        long milliseconds = TimePatternConverter.toMilliSeconds((String)source);
        TimePatternConverterTest.assertEquals((long)1855000L, (long)milliseconds);
    }

    public void testHMTimePattern() throws Exception {
        String source = new String("1h30m");
        long milliseconds = TimePatternConverter.toMilliSeconds((String)source);
        TimePatternConverterTest.assertEquals((long)5400000L, (long)milliseconds);
    }

    public void testSTimePattern2() throws Exception {
        String source = new String("15sec");
        long milliseconds = TimePatternConverter.toMilliSeconds((String)source);
        TimePatternConverterTest.assertEquals((long)15000L, (long)milliseconds);
    }

    public void testMTimePattern2() throws Exception {
        String source = new String("5min");
        long milliseconds = TimePatternConverter.toMilliSeconds((String)source);
        TimePatternConverterTest.assertEquals((long)300000L, (long)milliseconds);
    }

    public void testMTimePattern3() throws Exception {
        String source = new String("5MIN");
        long milliseconds = TimePatternConverter.toMilliSeconds((String)source);
        TimePatternConverterTest.assertEquals((long)300000L, (long)milliseconds);
    }

    public void testMSTimePattern2() throws Exception {
        String source = new String("4min2sec");
        long milliseconds = TimePatternConverter.toMilliSeconds((String)source);
        TimePatternConverterTest.assertEquals((long)242000L, (long)milliseconds);
    }

    public void testIllegalHMSTimePattern() {
        String source = new String("36h88m5s");
        try {
            TimePatternConverter.toMilliSeconds((String)source);
            TimePatternConverterTest.fail((String)"Should throw IllegalArgumentException");
        }
        catch (Exception e) {
            TimePatternConverterTest.assertIsInstanceOf(IllegalArgumentException.class, e);
            TimePatternConverterTest.assertEquals((String)"Minutes should contain a valid value between 0 and 59: 36h88m5s", (String)e.getMessage());
        }
    }

    public void testIllegalMSTimePattern() {
        String source = new String("55m75s");
        try {
            TimePatternConverter.toMilliSeconds((String)source);
            TimePatternConverterTest.fail((String)"Should throw IllegalArgumentException");
        }
        catch (Exception e) {
            TimePatternConverterTest.assertIsInstanceOf(IllegalArgumentException.class, e);
            TimePatternConverterTest.assertEquals((String)"Seconds should contain a valid value between 0 and 59: 55m75s", (String)e.getMessage());
        }
    }

    public void testIllegalHMTimePattern() throws Exception {
        String source = new String("1h89s");
        try {
            TimePatternConverter.toMilliSeconds((String)source);
            TimePatternConverterTest.fail((String)"Should throw IllegalArgumentException");
        }
        catch (Exception e) {
            TimePatternConverterTest.assertIsInstanceOf(IllegalArgumentException.class, e);
            TimePatternConverterTest.assertEquals((String)"Seconds should contain a valid value between 0 and 59: 1h89s", (String)e.getMessage());
        }
    }
}

