/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.converter.jaxp;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.nio.charset.Charset;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLEventWriter;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.apache.camel.CamelContext;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.impl.DefaultExchange;

public class StaxConverterTest
extends ContextTestSupport {
    private static final Charset ISO_8859_1 = Charset.forName("ISO-8859-1");
    private static final Charset UTF_8 = Charset.forName("UTF-8");
    private static final String TEST_XML = "<test>Test Message with umlaut \u00e4\u00f6\u00fc</test>";
    private static final String TEST_XML_WITH_XML_HEADER_ISO_8859_1 = "<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?><test>Test Message with umlaut \u00e4\u00f6\u00fc</test>";
    private static final ByteArrayInputStream TEST_XML_WITH_XML_HEADER_ISO_8859_1_AS_BYTE_ARRAY_STREAM = new ByteArrayInputStream("<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?><test>Test Message with umlaut \u00e4\u00f6\u00fc</test>".getBytes(ISO_8859_1));
    private static final String TEST_XML_WITH_XML_HEADER = "<?xml version=\"1.0\"?><test>Test Message with umlaut \u00e4\u00f6\u00fc</test>";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testEncodingXmlEventReader() throws Exception {
        TEST_XML_WITH_XML_HEADER_ISO_8859_1_AS_BYTE_ARRAY_STREAM.reset();
        XMLEventReader reader = null;
        XMLEventWriter writer = null;
        ByteArrayOutputStream output = null;
        try {
            reader = (XMLEventReader)this.context.getTypeConverter().mandatoryConvertTo(XMLEventReader.class, (Object)TEST_XML_WITH_XML_HEADER_ISO_8859_1_AS_BYTE_ARRAY_STREAM);
            output = new ByteArrayOutputStream();
            DefaultExchange exchange = new DefaultExchange((CamelContext)this.context);
            exchange.setProperty("CamelCharsetName", (Object)UTF_8.toString());
            writer = (XMLEventWriter)this.context.getTypeConverter().mandatoryConvertTo(XMLEventWriter.class, (Exchange)exchange, (Object)output);
            while (reader.hasNext()) {
                writer.add(reader.nextEvent());
            }
        }
        finally {
            if (reader != null) {
                reader.close();
            }
            if (writer != null) {
                writer.close();
            }
        }
        StaxConverterTest.assertNotNull((Object)output);
        String result = new String(output.toByteArray(), UTF_8.name());
        if (result.indexOf(39) > 0) {
            result = result.replace('\'', '\"');
        }
        boolean equals = TEST_XML_WITH_XML_HEADER.equals(result) || TEST_XML_WITH_XML_HEADER_ISO_8859_1.equals(result);
        StaxConverterTest.assertTrue((String)"Should match header", (boolean)equals);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testEncodingXmlStreamReader() throws Exception {
        TEST_XML_WITH_XML_HEADER_ISO_8859_1_AS_BYTE_ARRAY_STREAM.reset();
        XMLStreamReader reader = null;
        XMLStreamWriter writer = null;
        ByteArrayOutputStream output = null;
        try {
            reader = (XMLStreamReader)this.context.getTypeConverter().mandatoryConvertTo(XMLStreamReader.class, (Object)TEST_XML_WITH_XML_HEADER_ISO_8859_1_AS_BYTE_ARRAY_STREAM);
            output = new ByteArrayOutputStream();
            DefaultExchange exchange = new DefaultExchange((CamelContext)this.context);
            exchange.setProperty("CamelCharsetName", (Object)UTF_8.name());
            writer = (XMLStreamWriter)this.context.getTypeConverter().mandatoryConvertTo(XMLStreamWriter.class, (Exchange)exchange, (Object)output);
            block10: while (reader.hasNext()) {
                reader.next();
                switch (reader.getEventType()) {
                    case 7: {
                        writer.writeStartDocument();
                        continue block10;
                    }
                    case 8: {
                        writer.writeEndDocument();
                        continue block10;
                    }
                    case 1: {
                        writer.writeStartElement(reader.getName().getLocalPart());
                        continue block10;
                    }
                    case 4: {
                        writer.writeCharacters(reader.getText());
                        continue block10;
                    }
                    case 2: {
                        writer.writeEndElement();
                        continue block10;
                    }
                }
            }
        }
        finally {
            if (reader != null) {
                reader.close();
            }
            if (writer != null) {
                writer.close();
            }
        }
        StaxConverterTest.assertNotNull((Object)output);
        String result = new String(output.toByteArray(), UTF_8.name());
        StaxConverterTest.assertEquals((String)TEST_XML, (String)result);
    }
}

