/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.converter.jaxp;

import java.io.File;
import java.io.InputStream;
import java.io.Reader;
import java.nio.ByteBuffer;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stax.StAXSource;
import javax.xml.transform.stream.StreamSource;
import org.apache.camel.BytesSource;
import org.apache.camel.CamelContext;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.converter.jaxp.XmlConverter;
import org.apache.camel.impl.DefaultCamelContext;
import org.apache.camel.impl.DefaultExchange;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class XmlConverterTest
extends ContextTestSupport {
    @Override
    protected void setUp() throws Exception {
        XmlConverterTest.deleteDirectory("target/xml");
        super.setUp();
    }

    public void testToResultNoSource() throws Exception {
        XmlConverter conv = new XmlConverter();
        conv.toResult(null, null);
    }

    public void testToBytesSource() throws Exception {
        XmlConverter conv = new XmlConverter();
        BytesSource bs = conv.toBytesSource("<foo>bar</foo>".getBytes());
        XmlConverterTest.assertNotNull((Object)bs);
        XmlConverterTest.assertEquals((String)"<foo>bar</foo>", (String)new String(bs.getData()));
    }

    public void testToStringFromSourceNoSource() throws Exception {
        XmlConverter conv = new XmlConverter();
        Source source = null;
        String out = conv.toString(source, null);
        XmlConverterTest.assertEquals(null, (String)out);
    }

    public void testToStringWithBytesSource() throws Exception {
        XmlConverter conv = new XmlConverter();
        BytesSource source = conv.toBytesSource("<foo>bar</foo>".getBytes());
        String out = conv.toString((Source)source, null);
        XmlConverterTest.assertEquals((String)"<foo>bar</foo>", (String)out);
    }

    public void testToSource() throws Exception {
        XmlConverter conv = new XmlConverter();
        Source source = conv.toSource("<foo>bar</foo>");
        String out = conv.toString(source, null);
        XmlConverterTest.assertEquals((String)"<foo>bar</foo>", (String)out);
    }

    public void testToSourceUsingTypeConverter() throws Exception {
        Source source = (Source)this.context.getTypeConverter().convertTo(Source.class, (Object)"<foo>bar</foo>");
        String out = (String)this.context.getTypeConverter().convertTo(String.class, (Object)source);
        XmlConverterTest.assertEquals((String)"<foo>bar</foo>", (String)out);
        source = (Source)this.context.getTypeConverter().convertTo(Source.class, (Object)"<foo>baz</foo>");
        out = (String)this.context.getTypeConverter().convertTo(String.class, (Object)source);
        XmlConverterTest.assertEquals((String)"<foo>baz</foo>", (String)out);
    }

    public void testToByteArrayWithExchange() throws Exception {
        DefaultExchange exchange = new DefaultExchange((CamelContext)this.context);
        XmlConverter conv = new XmlConverter();
        BytesSource source = conv.toBytesSource("<foo>bar</foo>".getBytes());
        byte[] out = conv.toByteArray((Source)source, (Exchange)exchange);
        XmlConverterTest.assertEquals((String)"<foo>bar</foo>", (String)new String(out));
    }

    public void testToByteArrayWithNoExchange() throws Exception {
        XmlConverter conv = new XmlConverter();
        BytesSource source = conv.toBytesSource("<foo>bar</foo>".getBytes());
        byte[] out = conv.toByteArray((Source)source, null);
        XmlConverterTest.assertEquals((String)"<foo>bar</foo>", (String)new String(out));
    }

    public void testToDomSourceByDomSource() throws Exception {
        XmlConverter conv = new XmlConverter();
        DOMSource source = conv.toDOMSource("<foo>bar</foo>");
        DOMSource out = conv.toDOMSource((Source)source);
        XmlConverterTest.assertSame((Object)source, (Object)out);
    }

    public void testToDomSourceByByteArray() throws Exception {
        XmlConverter conv = new XmlConverter();
        byte[] bytes = "<foo>bar</foo>".getBytes();
        DOMSource source = conv.toDOMSource(bytes);
        XmlConverterTest.assertNotNull((Object)source);
        byte[] out = conv.toByteArray((Source)source, null);
        XmlConverterTest.assertEquals((String)new String(bytes), (String)new String(out));
    }

    public void testToDomSourceBySaxSource() throws Exception {
        XmlConverter conv = new XmlConverter();
        SAXSource source = conv.toSAXSource("<foo>bar</foo>", null);
        DOMSource out = conv.toDOMSource((Source)source);
        XmlConverterTest.assertNotSame((Object)source, (Object)out);
        XmlConverterTest.assertEquals((String)"<foo>bar</foo>", (String)conv.toString((Source)out, null));
    }

    public void testToDomSourceByStAXSource() throws Exception {
        XmlConverter conv = new XmlConverter();
        StAXSource source = conv.toStAXSource("<?xml version=\"1.0\" encoding=\"UTF-8\"?><foo>bar</foo>", null);
        DOMSource out = conv.toDOMSource((Source)source);
        XmlConverterTest.assertNotSame((Object)source, (Object)out);
        XmlConverterTest.assertEquals((String)"<foo>bar</foo>", (String)conv.toString((Source)out, null));
    }

    public void testToDomSourceByCustomSource() throws Exception {
        XmlConverter conv = new XmlConverter();
        Source dummy = new Source(){

            @Override
            public String getSystemId() {
                return null;
            }

            @Override
            public void setSystemId(String s) {
            }
        };
        DOMSource out = conv.toDOMSource(dummy);
        XmlConverterTest.assertNull((Object)out);
    }

    public void testToSaxSourceByInputStream() throws Exception {
        XmlConverter conv = new XmlConverter();
        InputStream is = (InputStream)this.context.getTypeConverter().convertTo(InputStream.class, (Object)"<foo>bar</foo>");
        SAXSource out = conv.toSAXSource(is, null);
        XmlConverterTest.assertNotNull((Object)out);
        XmlConverterTest.assertEquals((String)"<foo>bar</foo>", (String)conv.toString((Source)out, null));
    }

    public void testToStAXSourceByInputStream() throws Exception {
        XmlConverter conv = new XmlConverter();
        InputStream is = (InputStream)this.context.getTypeConverter().convertTo(InputStream.class, (Object)"<foo>bar</foo>");
        StAXSource out = conv.toStAXSource(is, null);
        XmlConverterTest.assertNotNull((Object)out);
        XmlConverterTest.assertEquals((String)"<foo>bar</foo>", (String)conv.toString((Source)out, null));
    }

    public void testToSaxSourceFromFile() throws Exception {
        XmlConverter conv = new XmlConverter();
        this.template.sendBodyAndHeader("file:target/xml", (Object)"<foo>bar</foo>", "CamelFileName", (Object)"myxml.xml");
        File file = new File("target/xml/myxml.xml");
        SAXSource out = conv.toSAXSource(file, null);
        XmlConverterTest.assertNotNull((Object)out);
        XmlConverterTest.assertEquals((String)"<foo>bar</foo>", (String)((String)this.context.getTypeConverter().convertTo(String.class, (Object)out)));
    }

    public void testToStAXSourceFromFile() throws Exception {
        XmlConverter conv = new XmlConverter();
        this.template.sendBodyAndHeader("file:target/xml", (Object)"<foo>bar</foo>", "CamelFileName", (Object)"myxml.xml");
        File file = new File("target/xml/myxml.xml");
        StAXSource out = conv.toStAXSource(file, null);
        XmlConverterTest.assertNotNull((Object)out);
        XmlConverterTest.assertEquals((String)"<foo>bar</foo>", (String)((String)this.context.getTypeConverter().convertTo(String.class, (Object)out)));
    }

    public void testToSaxSourceByDomSource() throws Exception {
        XmlConverter conv = new XmlConverter();
        DOMSource source = conv.toDOMSource("<foo>bar</foo>");
        SAXSource out = conv.toSAXSource((Source)source, null);
        XmlConverterTest.assertNotSame((Object)source, (Object)out);
        XmlConverterTest.assertEquals((String)"<foo>bar</foo>", (String)conv.toString((Source)out, null));
    }

    public void testToSaxSourceBySaxSource() throws Exception {
        XmlConverter conv = new XmlConverter();
        SAXSource source = conv.toSAXSource("<foo>bar</foo>", null);
        SAXSource out = conv.toSAXSource((Source)source, null);
        XmlConverterTest.assertSame((Object)source, (Object)out);
    }

    public void testToSaxSourceByCustomSource() throws Exception {
        XmlConverter conv = new XmlConverter();
        Source dummy = new Source(){

            @Override
            public String getSystemId() {
                return null;
            }

            @Override
            public void setSystemId(String s) {
            }
        };
        SAXSource out = conv.toSAXSource(dummy, null);
        XmlConverterTest.assertNull((Object)out);
    }

    public void testToStreamSourceByFile() throws Exception {
        XmlConverter conv = new XmlConverter();
        File file = new File("org/apache/camel/converter/stream/test.xml");
        StreamSource source = conv.toStreamSource(file);
        StreamSource out = conv.toStreamSource((Source)source, null);
        XmlConverterTest.assertSame((Object)source, (Object)out);
    }

    public void testToStreamSourceByStreamSource() throws Exception {
        DefaultExchange exchange = new DefaultExchange((CamelContext)this.context);
        XmlConverter conv = new XmlConverter();
        StreamSource source = conv.toStreamSource("<foo>bar</foo>".getBytes(), (Exchange)exchange);
        StreamSource out = conv.toStreamSource((Source)source, null);
        XmlConverterTest.assertSame((Object)source, (Object)out);
    }

    public void testToStreamSourceByDomSource() throws Exception {
        XmlConverter conv = new XmlConverter();
        DOMSource source = conv.toDOMSource("<foo>bar</foo>");
        StreamSource out = conv.toStreamSource((Source)source, null);
        XmlConverterTest.assertNotSame((Object)source, (Object)out);
        XmlConverterTest.assertEquals((String)"<foo>bar</foo>", (String)conv.toString((Source)out, null));
    }

    public void testToStreamSourceBySaxSource() throws Exception {
        XmlConverter conv = new XmlConverter();
        SAXSource source = conv.toSAXSource("<foo>bar</foo>", null);
        StreamSource out = conv.toStreamSource((Source)source, null);
        XmlConverterTest.assertNotSame((Object)source, (Object)out);
        XmlConverterTest.assertEquals((String)"<foo>bar</foo>", (String)conv.toString((Source)out, null));
    }

    public void testToStreamSourceByStAXSource() throws Exception {
        XmlConverter conv = new XmlConverter();
        StAXSource source = conv.toStAXSource("<foo>bar</foo>", null);
        StreamSource out = conv.toStreamSource((Source)source, null);
        XmlConverterTest.assertNotSame((Object)source, (Object)out);
        XmlConverterTest.assertEquals((String)"<foo>bar</foo>", (String)conv.toString((Source)out, null));
    }

    public void testToStreamSourceByCustomSource() throws Exception {
        XmlConverter conv = new XmlConverter();
        Source dummy = new Source(){

            @Override
            public String getSystemId() {
                return null;
            }

            @Override
            public void setSystemId(String s) {
            }
        };
        StreamSource out = conv.toStreamSource(dummy, null);
        XmlConverterTest.assertNull((Object)out);
    }

    public void testToStreamSourceByInputStream() throws Exception {
        XmlConverter conv = new XmlConverter();
        InputStream is = (InputStream)this.context.getTypeConverter().convertTo(InputStream.class, (Object)"<foo>bar</foo>");
        StreamSource out = conv.toStreamSource(is);
        XmlConverterTest.assertNotNull((Object)out);
        XmlConverterTest.assertEquals((String)"<foo>bar</foo>", (String)conv.toString((Source)out, null));
    }

    public void testToStreamSourceByReader() throws Exception {
        XmlConverter conv = new XmlConverter();
        Reader reader = (Reader)this.context.getTypeConverter().convertTo(Reader.class, (Object)"<foo>bar</foo>");
        StreamSource out = conv.toStreamSource(reader);
        XmlConverterTest.assertNotNull((Object)out);
        XmlConverterTest.assertEquals((String)"<foo>bar</foo>", (String)conv.toString((Source)out, null));
    }

    public void testToStreamSourceByByteArray() throws Exception {
        DefaultExchange exchange = new DefaultExchange((CamelContext)this.context);
        XmlConverter conv = new XmlConverter();
        byte[] bytes = (byte[])this.context.getTypeConverter().convertTo(byte[].class, (Object)"<foo>bar</foo>");
        StreamSource out = conv.toStreamSource(bytes, (Exchange)exchange);
        XmlConverterTest.assertNotNull((Object)out);
        XmlConverterTest.assertEquals((String)"<foo>bar</foo>", (String)conv.toString((Source)out, null));
    }

    public void testToStreamSourceByByteBuffer() throws Exception {
        DefaultExchange exchange = new DefaultExchange((CamelContext)this.context);
        XmlConverter conv = new XmlConverter();
        ByteBuffer bytes = (ByteBuffer)this.context.getTypeConverter().convertTo(ByteBuffer.class, (Object)"<foo>bar</foo>");
        StreamSource out = conv.toStreamSource(bytes, (Exchange)exchange);
        XmlConverterTest.assertNotNull((Object)out);
        XmlConverterTest.assertEquals((String)"<foo>bar</foo>", (String)conv.toString((Source)out, null));
    }

    public void testToReaderFromSource() throws Exception {
        XmlConverter conv = new XmlConverter();
        SAXSource source = conv.toSAXSource("<foo>bar</foo>", null);
        Reader out = conv.toReaderFromSource((Source)source, null);
        XmlConverterTest.assertNotNull((Object)out);
        XmlConverterTest.assertEquals((String)"<foo>bar</foo>", (String)((String)this.context.getTypeConverter().convertTo(String.class, (Object)out)));
    }

    public void testToDomSourceFromInputStream() throws Exception {
        XmlConverter conv = new XmlConverter();
        InputStream is = (InputStream)this.context.getTypeConverter().convertTo(InputStream.class, (Object)"<foo>bar</foo>");
        DOMSource out = conv.toDOMSource(is);
        XmlConverterTest.assertNotNull((Object)out);
        XmlConverterTest.assertEquals((String)"<foo>bar</foo>", (String)((String)this.context.getTypeConverter().convertTo(String.class, (Object)out)));
    }

    public void testToDomSourceFromFile() throws Exception {
        XmlConverter conv = new XmlConverter();
        this.template.sendBodyAndHeader("file:target/xml", (Object)"<foo>bar</foo>", "CamelFileName", (Object)"myxml.xml");
        File file = new File("target/xml/myxml.xml");
        DOMSource out = conv.toDOMSource(file);
        XmlConverterTest.assertNotNull((Object)out);
        XmlConverterTest.assertEquals((String)"<foo>bar</foo>", (String)((String)this.context.getTypeConverter().convertTo(String.class, (Object)out)));
    }

    public void testToDomElement() throws Exception {
        XmlConverter conv = new XmlConverter();
        SAXSource source = conv.toSAXSource("<foo>bar</foo>", null);
        Element out = conv.toDOMElement((Source)source);
        XmlConverterTest.assertNotNull((Object)out);
        XmlConverterTest.assertEquals((String)"<foo>bar</foo>", (String)((String)this.context.getTypeConverter().convertTo(String.class, (Object)out)));
    }

    public void testToDomElementFromDocumentNode() throws Exception {
        XmlConverter conv = new XmlConverter();
        Document doc = (Document)this.context.getTypeConverter().convertTo(Document.class, (Object)"<?xml version=\"1.0\" encoding=\"UTF-8\"?><foo>bar</foo>");
        Element out = conv.toDOMElement((Node)doc);
        XmlConverterTest.assertNotNull((Object)out);
        XmlConverterTest.assertEquals((String)"<foo>bar</foo>", (String)((String)this.context.getTypeConverter().convertTo(String.class, (Object)out)));
    }

    public void testToDomElementFromElementNode() throws Exception {
        XmlConverter conv = new XmlConverter();
        Document doc = (Document)this.context.getTypeConverter().convertTo(Document.class, (Object)"<?xml version=\"1.0\" encoding=\"UTF-8\"?><foo>bar</foo>");
        Element out = conv.toDOMElement((Node)doc.getDocumentElement());
        XmlConverterTest.assertNotNull((Object)out);
        XmlConverterTest.assertEquals((String)"<foo>bar</foo>", (String)((String)this.context.getTypeConverter().convertTo(String.class, (Object)out)));
    }

    public void testToDocumentFromBytes() throws Exception {
        XmlConverter conv = new XmlConverter();
        byte[] bytes = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><foo>bar</foo>".getBytes();
        Document out = conv.toDOMDocument(bytes);
        XmlConverterTest.assertNotNull((Object)out);
        XmlConverterTest.assertEquals((String)"<foo>bar</foo>", (String)((String)this.context.getTypeConverter().convertTo(String.class, (Object)out)));
    }

    public void testToDocumentFromInputStream() throws Exception {
        XmlConverter conv = new XmlConverter();
        InputStream is = (InputStream)this.context.getTypeConverter().convertTo(InputStream.class, (Object)"<?xml version=\"1.0\" encoding=\"UTF-8\"?><foo>bar</foo>");
        Document out = conv.toDOMDocument(is);
        XmlConverterTest.assertNotNull((Object)out);
        XmlConverterTest.assertEquals((String)"<foo>bar</foo>", (String)((String)this.context.getTypeConverter().convertTo(String.class, (Object)out)));
    }

    public void testToInputStreamFromDocument() throws Exception {
        XmlConverter conv = new XmlConverter();
        Document doc = (Document)this.context.getTypeConverter().convertTo(Document.class, (Object)"<?xml version=\"1.0\" encoding=\"UTF-8\"?><foo>bar</foo>");
        InputStream is = conv.toInputStream(doc, null);
        XmlConverterTest.assertNotNull((Object)is);
        XmlConverterTest.assertEquals((String)"<foo>bar</foo>", (String)((String)this.context.getTypeConverter().convertTo(String.class, (Object)is)));
    }

    public void testToInputStreamNonAsciiFromDocument() throws Exception {
        XmlConverter conv = new XmlConverter();
        Document doc = (Document)this.context.getTypeConverter().convertTo(Document.class, (Object)"<?xml version=\"1.0\" encoding=\"UTF-8\"?><foo>\u99f1\u99ddb\u00e4r</foo>");
        InputStream is = conv.toInputStream(doc, null);
        XmlConverterTest.assertNotNull((Object)is);
        XmlConverterTest.assertEquals((String)"<foo>\u99f1\u99ddb\u00e4r</foo>", (String)((String)this.context.getTypeConverter().convertTo(String.class, (Object)is)));
    }

    public void testToDocumentFromFile() throws Exception {
        XmlConverter conv = new XmlConverter();
        File file = new File("src/test/resources/org/apache/camel/converter/stream/test.xml");
        Document out = conv.toDOMDocument(file);
        XmlConverterTest.assertNotNull((Object)out);
        String s = (String)this.context.getTypeConverter().convertTo(String.class, (Object)out);
        XmlConverterTest.assertTrue((boolean)s.contains("<firstName>James</firstName>"));
    }

    public void testToInputStreamByDomSource() throws Exception {
        XmlConverter conv = new XmlConverter();
        DOMSource source = conv.toDOMSource("<foo>bar</foo>");
        InputStream out = conv.toInputStream(source, null);
        XmlConverterTest.assertNotSame((Object)source, (Object)out);
        String s = (String)this.context.getTypeConverter().convertTo(String.class, (Object)out);
        XmlConverterTest.assertEquals((String)"<foo>bar</foo>", (String)s);
    }

    public void testToInputStreamNonAsciiByDomSource() throws Exception {
        XmlConverter conv = new XmlConverter();
        DOMSource source = conv.toDOMSource("<foo>\u99f1\u99ddb\u00e4r</foo>");
        InputStream out = conv.toInputStream(source, null);
        XmlConverterTest.assertNotSame((Object)source, (Object)out);
        String s = (String)this.context.getTypeConverter().convertTo(String.class, (Object)out);
        XmlConverterTest.assertEquals((String)"<foo>\u99f1\u99ddb\u00e4r</foo>", (String)s);
    }

    public void testToInputSource() throws Exception {
        XmlConverter conv = new XmlConverter();
        InputStream is = (InputStream)this.context.getTypeConverter().convertTo(InputStream.class, (Object)"<foo>bar</foo>");
        InputSource out = conv.toInputSource(is, null);
        XmlConverterTest.assertNotNull((Object)out);
        XmlConverterTest.assertNotNull((Object)out.getByteStream());
    }

    public void testToInputSourceFromFile() throws Exception {
        XmlConverter conv = new XmlConverter();
        File file = new File("src/test/resources/org/apache/camel/converter/stream/test.xml");
        InputSource out = conv.toInputSource(file, null);
        XmlConverterTest.assertNotNull((Object)out);
        XmlConverterTest.assertNotNull((Object)out.getByteStream());
    }

    public void testOutOptionsFromCamelContext() throws Exception {
        DefaultCamelContext context = new DefaultCamelContext();
        DefaultExchange exchange = new DefaultExchange((CamelContext)context);
        context.getProperties().put("org.apache.camel.xmlconverter.output.encoding", "UTF-8");
        context.getProperties().put("org.apache.camel.xmlconverter.output.standalone", "no");
        XmlConverter conv = new XmlConverter();
        SAXSource source = conv.toSAXSource("<foo>bar</foo>", (Exchange)exchange);
        DOMSource out = conv.toDOMSource((Source)source);
        XmlConverterTest.assertNotSame((Object)source, (Object)out);
        XmlConverterTest.assertEquals((String)"<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"no\"?><foo>bar</foo>", (String)conv.toString((Source)out, (Exchange)exchange));
    }

    public void testNodeListToNode() throws Exception {
        Document document = (Document)this.context.getTypeConverter().convertTo(Document.class, (Object)"<?xml version=\"1.0\" encoding=\"UTF-8\"?><foo><hello>Hello World</hello></foo>");
        NodeList nl = document.getElementsByTagName("hello");
        XmlConverterTest.assertEquals((int)1, (int)nl.getLength());
        Node node = (Node)this.context.getTypeConverter().convertTo(Node.class, (Object)nl);
        XmlConverterTest.assertNotNull((Object)node);
        document = (Document)this.context.getTypeConverter().convertTo(Document.class, (Object)"<?xml version=\"1.0\" encoding=\"UTF-8\"?><foo><hello>Hello World</hello><hello>Hello Camel</hello></foo>");
        nl = document.getElementsByTagName("hello");
        XmlConverterTest.assertEquals((int)2, (int)nl.getLength());
        node = (Node)this.context.getTypeConverter().convertTo(Node.class, (Object)nl);
        XmlConverterTest.assertNull((Object)node);
        document = (Document)this.context.getTypeConverter().convertTo(Document.class, (Object)"<?xml version=\"1.0\" encoding=\"UTF-8\"?><foo><hello>Hello World</hello></foo>");
        nl = document.getElementsByTagName("hello");
        XmlConverterTest.assertEquals((int)1, (int)nl.getLength());
        node = (Node)this.context.getTypeConverter().convertTo(Node.class, (Object)nl);
        XmlConverterTest.assertNotNull((Object)node);
    }
}

