/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.converter.myconverter;

import java.math.BigDecimal;
import org.apache.camel.Converter;
import org.apache.camel.TypeConverter;
import org.apache.camel.converter.PurchaseOrder;
import org.apache.camel.spi.TypeConverterAware;

@Converter
public class PurchaseOrderConverter
implements TypeConverterAware {
    private TypeConverter converter;

    public void setTypeConverter(TypeConverter parentTypeConverter) {
        this.converter = parentTypeConverter;
    }

    @Converter
    public PurchaseOrder toPurchaseOrder(byte[] data) {
        String s = (String)this.converter.convertTo(String.class, (Object)data);
        if (s == null || s.length() < 30) {
            throw new IllegalArgumentException("data is invalid");
        }
        s = s.replaceAll("##START##", "");
        s = s.replaceAll("##END##", "");
        String name = s.substring(0, 9).trim();
        String s2 = s.substring(10, 19).trim();
        String s3 = s.substring(20).trim();
        BigDecimal price = new BigDecimal(s2);
        price.setScale(2);
        Integer amount = (Integer)this.converter.convertTo(Integer.class, (Object)s3);
        PurchaseOrder order = new PurchaseOrder(name, price, amount);
        return order;
    }
}

