/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.converter.stream;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.Serializable;
import javax.xml.transform.Source;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamSource;
import org.apache.camel.CamelContext;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.StreamCache;
import org.apache.camel.converter.IOConverter;
import org.apache.camel.converter.jaxp.XmlConverter;
import org.apache.camel.converter.stream.StreamCacheConverter;
import org.apache.camel.impl.DefaultExchange;
import org.xml.sax.InputSource;

public class StreamCacheConverterTest
extends ContextTestSupport {
    private static final String TEST_FILE = "org/apache/camel/converter/stream/test.xml";
    private static final String MESSAGE = "<test>This is a test</test>";
    private Exchange exchange;

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.exchange = new DefaultExchange((CamelContext)this.context);
    }

    public void testConvertToStreamCache() throws Exception {
        this.context.start();
        ByteArrayInputStream inputStream = new ByteArrayInputStream(MESSAGE.getBytes());
        StreamCache streamCache = StreamCacheConverter.convertToStreamCache((SAXSource)new SAXSource(new InputSource(inputStream)), (Exchange)this.exchange);
        String message = (String)this.exchange.getContext().getTypeConverter().convertTo(String.class, (Object)streamCache);
        StreamCacheConverterTest.assertNotNull((Object)message);
        StreamCacheConverterTest.assertEquals((String)"The converted message is wrong", (String)MESSAGE, (String)message);
    }

    public void testConvertToStreamCacheStreamSource() throws Exception {
        this.context.start();
        StreamSource source = new StreamSource(this.getTestFileStream());
        StreamCache cache = StreamCacheConverter.convertToStreamCache((StreamSource)source, (Exchange)this.exchange);
        XmlConverter converter = new XmlConverter();
        StreamCacheConverterTest.assertNotNull((Object)converter.toString((Source)cache, null));
        cache.reset();
        StreamCacheConverterTest.assertNotNull((Object)converter.toString((Source)cache, null));
    }

    public void testConvertToStreamCacheInputStream() throws Exception {
        this.context.start();
        InputStream is = this.getTestFileStream();
        InputStream cache = (InputStream)StreamCacheConverter.convertToStreamCache((InputStream)is, (Exchange)this.exchange);
        String data = IOConverter.toString((InputStream)cache, null);
        cache.reset();
        String data2 = IOConverter.toString((InputStream)cache, null);
        StreamCacheConverterTest.assertEquals((String)data, (String)data2);
    }

    public void testConvertToStreamCacheInputStreamWithFileCache() throws Exception {
        this.exchange.getContext().getStreamCachingStrategy().setSpoolThreshold(1L);
        this.context.start();
        InputStream is = this.getTestFileStream();
        InputStream cache = (InputStream)StreamCacheConverter.convertToStreamCache((InputStream)is, (Exchange)this.exchange);
        StreamCacheConverterTest.assertNotNull((Object)IOConverter.toString((InputStream)cache, null));
        try {
            cache.reset();
            this.exchange.getUnitOfWork().done(this.exchange);
            StreamCacheConverterTest.fail((String)"except the exception here");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void testConvertToSerializable() throws Exception {
        this.context.start();
        InputStream is = this.getTestFileStream();
        StreamCache cache = StreamCacheConverter.convertToStreamCache((InputStream)is, (Exchange)this.exchange);
        Serializable ser = StreamCacheConverter.convertToSerializable((StreamCache)cache, (Exchange)this.exchange);
        StreamCacheConverterTest.assertNotNull((Object)ser);
    }

    public void testConvertToByteArray() throws Exception {
        this.context.start();
        InputStream is = this.getTestFileStream();
        StreamCache cache = StreamCacheConverter.convertToStreamCache((InputStream)is, (Exchange)this.exchange);
        byte[] bytes = StreamCacheConverter.convertToByteArray((StreamCache)cache, (Exchange)this.exchange);
        StreamCacheConverterTest.assertNotNull((Object)bytes);
    }

    protected InputStream getTestFileStream() {
        InputStream answer = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream(TEST_FILE);
        StreamCacheConverterTest.assertNotNull((String)"Should have found the file: org/apache/camel/converter/stream/test.xml on the classpath", (Object)answer);
        return answer;
    }

    @Override
    public boolean isUseRouteBuilder() {
        return false;
    }
}

