/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl;

import java.io.InputStream;
import java.io.OutputStream;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.impl.JndiRegistry;
import org.apache.camel.spi.DataFormat;

public class DataFormatContextAwareTest
extends ContextTestSupport {
    private MyDataFormat my = new MyDataFormat();

    @Override
    protected JndiRegistry createRegistry() throws Exception {
        JndiRegistry jndi = super.createRegistry();
        jndi.bind("my", (Object)this.my);
        return jndi;
    }

    public void testLanguageCamelContextAware() throws Exception {
        DataFormat df = this.context.resolveDataFormat("my");
        DataFormatContextAwareTest.assertNotNull((Object)df);
        MyDataFormat me = DataFormatContextAwareTest.assertIsInstanceOf(MyDataFormat.class, df);
        DataFormatContextAwareTest.assertNotNull((Object)me.getCamelContext());
    }

    private static class MyDataFormat
    implements DataFormat,
    CamelContextAware {
        private CamelContext camelContext;

        private MyDataFormat() {
        }

        public CamelContext getCamelContext() {
            return this.camelContext;
        }

        public void setCamelContext(CamelContext camelContext) {
            this.camelContext = camelContext;
        }

        public void marshal(Exchange exchange, Object graph, OutputStream stream) throws Exception {
        }

        public Object unmarshal(Exchange exchange, InputStream stream) throws Exception {
            return null;
        }
    }
}

