/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.RouteDefinition;

public class DefaultCamelContextSuspendResumeRouteStartupOrderTest
extends ContextTestSupport {
    public void testSuspendResume() throws Exception {
        DefaultCamelContextSuspendResumeRouteStartupOrderTest.assertFalse((boolean)this.context.isSuspended());
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedBodiesReceived(new Object[]{"A"});
        this.template.sendBody("seda:foo", (Object)"A");
        this.assertMockEndpointsSatisfied();
        this.log.info("Suspending");
        this.resetMocks();
        mock.expectedMessageCount(0);
        this.context.suspend();
        this.template.sendBody("seda:foo", (Object)"B");
        mock.assertIsSatisfied(1000L);
        DefaultCamelContextSuspendResumeRouteStartupOrderTest.assertTrue((boolean)this.context.isSuspended());
        this.log.info("Resuming");
        this.resetMocks();
        mock.expectedBodiesReceived(new Object[]{"B"});
        this.context.resume();
        this.assertMockEndpointsSatisfied();
        DefaultCamelContextSuspendResumeRouteStartupOrderTest.assertFalse((boolean)this.context.isSuspended());
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                ((RouteDefinition)this.from("seda:foo").routeId("C").startupOrder(3).to("log:foo")).to("direct:bar");
                ((RouteDefinition)this.from("direct:baz").routeId("A").startupOrder(1).to("log:baz")).to("mock:result");
                ((RouteDefinition)this.from("direct:bar").routeId("B").startupOrder(2).to("log:bar")).to("direct:baz");
            }
        };
    }
}

