/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl;

import java.util.HashSet;
import org.apache.camel.CamelContext;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.impl.DefaultExchange;
import org.apache.camel.impl.DefaultHeaderFilterStrategy;

public class DefaultHeaderFilterStrategyTest
extends ContextTestSupport {
    public void testSimpleDefaultHeaderFilterStrategy() {
        DefaultHeaderFilterStrategy comp = new DefaultHeaderFilterStrategy();
        comp.setAllowNullValues(true);
        DefaultHeaderFilterStrategyTest.assertEquals((boolean)true, (boolean)comp.isAllowNullValues());
        comp.setLowerCase(true);
        DefaultHeaderFilterStrategyTest.assertEquals((boolean)true, (boolean)comp.isLowerCase());
        comp.setCaseInsensitive(true);
        DefaultHeaderFilterStrategyTest.assertEquals((boolean)true, (boolean)comp.isCaseInsensitive());
    }

    public void testInFilterDefaultHeaderFilterStrategy() {
        DefaultHeaderFilterStrategy comp = new DefaultHeaderFilterStrategy();
        HashSet<String> set = new HashSet<String>();
        set.add("foo");
        comp.setInFilter(set);
        DefaultHeaderFilterStrategyTest.assertEquals(set, (Object)comp.getInFilter());
    }

    public void testInFilterDoFilterDefaultHeaderFilterStrategy() {
        DefaultHeaderFilterStrategy comp = new DefaultHeaderFilterStrategy();
        HashSet<String> set = new HashSet<String>();
        set.add("foo");
        comp.setInFilter(set);
        DefaultExchange exchange = new DefaultExchange((CamelContext)this.context);
        exchange.getIn().setHeader("bar", (Object)123);
        exchange.getIn().setHeader("foo", (Object)"cheese");
        DefaultHeaderFilterStrategyTest.assertFalse((boolean)comp.applyFilterToExternalHeaders("bar", (Object)123, (Exchange)exchange));
        DefaultHeaderFilterStrategyTest.assertTrue((boolean)comp.applyFilterToExternalHeaders("foo", (Object)"cheese", (Exchange)exchange));
    }

    public void testOutFilterDefaultHeaderFilterStrategy() {
        DefaultHeaderFilterStrategy comp = new DefaultHeaderFilterStrategy();
        HashSet<String> set = new HashSet<String>();
        set.add("foo");
        comp.setOutFilter(set);
        DefaultHeaderFilterStrategyTest.assertEquals(set, (Object)comp.getOutFilter());
    }

    public void testOutFilterDoFilterDefaultHeaderFilterStrategy() {
        DefaultHeaderFilterStrategy comp = new DefaultHeaderFilterStrategy();
        HashSet<String> set = new HashSet<String>();
        set.add("foo");
        comp.setOutFilter(set);
        DefaultExchange exchange = new DefaultExchange((CamelContext)this.context);
        exchange.getIn().setHeader("bar", (Object)123);
        exchange.getIn().setHeader("foo", (Object)"cheese");
        DefaultHeaderFilterStrategyTest.assertFalse((boolean)comp.applyFilterToCamelHeaders("bar", (Object)123, (Exchange)exchange));
        DefaultHeaderFilterStrategyTest.assertTrue((boolean)comp.applyFilterToCamelHeaders("foo", (Object)"cheese", (Exchange)exchange));
    }

    public void testCaseInsensitiveHeaderNameDoFilterDefaultHeaderFilterStrategy() {
        DefaultHeaderFilterStrategy comp = new DefaultHeaderFilterStrategy();
        comp.setCaseInsensitive(true);
        HashSet<String> set = new HashSet<String>();
        set.add("Content-Type");
        comp.setOutFilter(set);
        DefaultExchange exchange = new DefaultExchange((CamelContext)this.context);
        exchange.getIn().setHeader("content-type", (Object)"application/xml");
        exchange.getIn().setHeader("Content-Type", (Object)"application/json");
        DefaultHeaderFilterStrategyTest.assertTrue((boolean)comp.applyFilterToCamelHeaders("content-type", (Object)"application/xml", (Exchange)exchange));
        DefaultHeaderFilterStrategyTest.assertTrue((boolean)comp.applyFilterToCamelHeaders("Content-Type", (Object)"application/json", (Exchange)exchange));
    }
}

