/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl;

import junit.framework.TestCase;
import org.apache.camel.NoSuchBeanException;
import org.apache.camel.impl.DefaultCamelContext;
import org.apache.camel.impl.SimpleRegistry;
import org.apache.camel.spi.Registry;

public class RegistryLookupTypeClassCastExceptionTest
extends TestCase {
    public void testLookupOk() throws Exception {
        SimpleRegistry simple = new SimpleRegistry();
        MyClass my = new MyClass();
        simple.put((Object)"my", (Object)my);
        RegistryLookupTypeClassCastExceptionTest.assertEquals((Object)my, (Object)simple.lookupByName("my"));
        RegistryLookupTypeClassCastExceptionTest.assertEquals((Object)my, (Object)simple.lookupByNameAndType("my", MyClass.class));
        RegistryLookupTypeClassCastExceptionTest.assertNull((Object)simple.lookupByName("foo"));
        RegistryLookupTypeClassCastExceptionTest.assertNull((Object)simple.lookupByNameAndType("foo", MyClass.class));
    }

    public void testCamelContextLookupOk() throws Exception {
        SimpleRegistry simple = new SimpleRegistry();
        DefaultCamelContext context = new DefaultCamelContext((Registry)simple);
        MyClass my = new MyClass();
        simple.put((Object)"my", (Object)my);
        RegistryLookupTypeClassCastExceptionTest.assertEquals((Object)my, (Object)context.getRegistry().lookupByName("my"));
        RegistryLookupTypeClassCastExceptionTest.assertEquals((Object)my, (Object)context.getRegistry().lookupByNameAndType("my", MyClass.class));
        RegistryLookupTypeClassCastExceptionTest.assertNull((Object)context.getRegistry().lookupByName("foo"));
        RegistryLookupTypeClassCastExceptionTest.assertNull((Object)context.getRegistry().lookupByNameAndType("foo", MyClass.class));
    }

    public void testLookupClassCast() throws Exception {
        SimpleRegistry simple = new SimpleRegistry();
        MyClass my = new MyClass();
        simple.put((Object)"my", (Object)my);
        try {
            simple.lookupByNameAndType("my", String.class);
            RegistryLookupTypeClassCastExceptionTest.fail((String)"Should have thrown exception");
        }
        catch (NoSuchBeanException e) {
            RegistryLookupTypeClassCastExceptionTest.assertEquals((String)"my", (String)e.getName());
            RegistryLookupTypeClassCastExceptionTest.assertTrue((boolean)e.getMessage().endsWith("expected type was: class java.lang.String"));
        }
    }

    public void testCamelContextLookupClassCast() throws Exception {
        SimpleRegistry simple = new SimpleRegistry();
        DefaultCamelContext context = new DefaultCamelContext((Registry)simple);
        MyClass my = new MyClass();
        simple.put((Object)"my", (Object)my);
        try {
            context.getRegistry().lookupByNameAndType("my", String.class);
            RegistryLookupTypeClassCastExceptionTest.fail((String)"Should have thrown exception");
        }
        catch (NoSuchBeanException e) {
            RegistryLookupTypeClassCastExceptionTest.assertEquals((String)"my", (String)e.getName());
            RegistryLookupTypeClassCastExceptionTest.assertTrue((boolean)e.getMessage().endsWith("expected type was: class java.lang.String"));
        }
    }

    public static class MyClass {
    }
}

