/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Route;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.spi.RoutePolicy;
import org.apache.camel.support.RoutePolicySupport;

public class RoutePolicyCallbackTest
extends ContextTestSupport {
    protected MyRoutePolicy policy = new MyRoutePolicy();

    protected MyRoutePolicy getAndInitMyRoutePolicy() {
        return this.policy;
    }

    public void testCallback() throws Exception {
        this.policy = this.getAndInitMyRoutePolicy();
        RoutePolicyCallbackTest.assertTrue((boolean)this.policy.doStart);
        RoutePolicyCallbackTest.assertTrue((boolean)this.policy.init);
        RoutePolicyCallbackTest.assertFalse((boolean)this.policy.begin);
        RoutePolicyCallbackTest.assertFalse((boolean)this.policy.done);
        this.getMockEndpoint("mock:result").expectedMessageCount(1);
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
        RoutePolicyCallbackTest.assertTrue((boolean)this.policy.begin);
        RoutePolicyCallbackTest.assertTrue((boolean)this.policy.done);
        RoutePolicyCallbackTest.assertFalse((boolean)this.policy.suspend);
        this.context.suspendRoute("foo");
        RoutePolicyCallbackTest.assertTrue((boolean)this.policy.suspend);
        RoutePolicyCallbackTest.assertFalse((boolean)this.policy.resume);
        this.context.resumeRoute("foo");
        RoutePolicyCallbackTest.assertTrue((boolean)this.policy.resume);
        RoutePolicyCallbackTest.assertFalse((boolean)this.policy.stop);
        this.context.stopRoute("foo");
        RoutePolicyCallbackTest.assertTrue((boolean)this.policy.stop);
        this.policy.start = false;
        RoutePolicyCallbackTest.assertFalse((boolean)this.policy.start);
        this.context.startRoute("foo");
        RoutePolicyCallbackTest.assertTrue((boolean)this.policy.start);
        RoutePolicyCallbackTest.assertFalse((boolean)this.policy.remove);
        this.context.stopRoute("foo");
        this.context.removeRoute("foo");
        RoutePolicyCallbackTest.assertTrue((boolean)this.policy.remove);
        this.context.stop();
        RoutePolicyCallbackTest.assertTrue((boolean)this.policy.doStop);
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                this.from("direct:start").routeId("foo").routePolicy(new RoutePolicy[]{RoutePolicyCallbackTest.this.policy}).to("mock:result");
            }
        };
    }

    public static class MyRoutePolicy
    extends RoutePolicySupport {
        boolean begin;
        boolean done;
        boolean init;
        boolean remove;
        boolean resume;
        boolean start;
        boolean stop;
        boolean suspend;
        boolean doStart;
        boolean doStop;

        public void onExchangeBegin(Route route, Exchange exchange) {
            this.begin = true;
        }

        public void onExchangeDone(Route route, Exchange exchange) {
            this.done = true;
        }

        public void onInit(Route route) {
            this.init = true;
        }

        public void onRemove(Route route) {
            this.remove = true;
        }

        public void onResume(Route route) {
            this.resume = true;
        }

        public void onStart(Route route) {
            this.start = true;
        }

        public void onStop(Route route) {
            this.stop = true;
        }

        public void onSuspend(Route route) {
            this.suspend = true;
        }

        protected void doStop() throws Exception {
            this.doStop = true;
        }

        protected void doStart() throws Exception {
            this.doStart = true;
        }
    }
}

