/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl;

import org.apache.camel.Consumer;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Endpoint;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.impl.MockScheduledPollConsumer;
import org.apache.camel.spi.PollingConsumerPollStrategy;

public class ScheduledPollConsumerTest
extends ContextTestSupport {
    private static boolean rollback;
    private static int counter;
    private static String event;

    public void testExceptionOnPollAndCanStartAgain() throws Exception {
        final Exception expectedException = new Exception("Hello, I should be thrown on shutdown only!");
        MockEndpoint endpoint = this.getMockEndpoint("mock:foo");
        MockScheduledPollConsumer consumer = new MockScheduledPollConsumer((Endpoint)endpoint, expectedException);
        consumer.setPollStrategy(new PollingConsumerPollStrategy(){

            public boolean begin(Consumer consumer, Endpoint endpoint) {
                return true;
            }

            public void commit(Consumer consumer, Endpoint endpoint, int polledMessages) {
            }

            public boolean rollback(Consumer consumer, Endpoint endpoint, int retryCounter, Exception e) throws Exception {
                if (e == expectedException) {
                    rollback = true;
                }
                return false;
            }
        });
        consumer.start();
        consumer.run();
        consumer.stop();
        ScheduledPollConsumerTest.assertEquals((String)"Should have rollback", (boolean)true, (boolean)rollback);
        rollback = false;
        consumer.setExceptionToThrowOnPoll(null);
        consumer.start();
        consumer.run();
        consumer.stop();
        ScheduledPollConsumerTest.assertEquals((String)"Should not have rollback", (boolean)false, (boolean)rollback);
    }

    public void testRetryAtMostThreeTimes() throws Exception {
        counter = 0;
        event = "";
        Exception expectedException = new Exception("Hello, I should be thrown on shutdown only!");
        MockEndpoint endpoint = this.getMockEndpoint("mock:foo");
        MockScheduledPollConsumer consumer = new MockScheduledPollConsumer((Endpoint)endpoint, expectedException);
        consumer.setPollStrategy(new PollingConsumerPollStrategy(){

            public boolean begin(Consumer consumer, Endpoint endpoint) {
                return true;
            }

            public void commit(Consumer consumer, Endpoint endpoint, int polledMessages) {
                event = event + "commit";
            }

            public boolean rollback(Consumer consumer, Endpoint endpoint, int retryCounter, Exception e) throws Exception {
                event = event + "rollback";
                counter++;
                return retryCounter < 3;
            }
        });
        consumer.setUseFixedDelay(true);
        consumer.setDelay(60000L);
        consumer.start();
        consumer.run();
        consumer.stop();
        ScheduledPollConsumerTest.assertEquals((int)4, (int)counter);
        ScheduledPollConsumerTest.assertEquals((String)"rollbackrollbackrollbackrollback", (String)event);
    }

    public void testNoExceptionOnPoll() throws Exception {
        MockEndpoint endpoint = this.getMockEndpoint("mock:foo");
        MockScheduledPollConsumer consumer = new MockScheduledPollConsumer((Endpoint)endpoint, null);
        consumer.start();
        consumer.run();
        consumer.stop();
    }

    static {
        event = "";
    }
}

