/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl;

import java.util.Map;
import junit.framework.TestCase;
import org.apache.camel.NoSuchBeanException;
import org.apache.camel.impl.SimpleRegistry;

public class SimpleRegistryTest
extends TestCase {
    private SimpleRegistry registry;

    protected void setUp() throws Exception {
        this.registry = new SimpleRegistry();
        this.registry.put((Object)"a", (Object)"b");
        this.registry.put((Object)"c", (Object)1);
    }

    public void testLookupByName() {
        SimpleRegistryTest.assertEquals((Object)"b", (Object)this.registry.lookupByName("a"));
    }

    public void testLookupByWrongName() {
        SimpleRegistryTest.assertNull((Object)this.registry.lookupByName("x"));
    }

    public void testLookupByNameAndType() {
        SimpleRegistryTest.assertEquals((String)"b", (String)((String)this.registry.lookupByNameAndType("a", String.class)));
    }

    public void testLookupByNameAndWrongType() {
        try {
            this.registry.lookupByNameAndType("a", Float.class);
            SimpleRegistryTest.fail();
        }
        catch (NoSuchBeanException e) {
            SimpleRegistryTest.assertEquals((String)"a", (String)e.getName());
            SimpleRegistryTest.assertTrue((boolean)e.getMessage().endsWith("of type: java.lang.String expected type was: class java.lang.Float"));
        }
    }

    public void testLookupByType() {
        Map map = this.registry.findByTypeWithName(String.class);
        SimpleRegistryTest.assertEquals((int)1, (int)map.size());
        SimpleRegistryTest.assertEquals((Object)"b", map.get("a"));
        map = this.registry.findByTypeWithName(Object.class);
        SimpleRegistryTest.assertEquals((int)2, (int)map.size());
        SimpleRegistryTest.assertEquals((Object)"b", map.get("a"));
        SimpleRegistryTest.assertEquals((Object)1, map.get("c"));
    }

    public void testLookupByWrongType() {
        Map map = this.registry.findByTypeWithName(Float.class);
        SimpleRegistryTest.assertEquals((int)0, (int)map.size());
    }
}

