/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl;

import org.apache.camel.CamelContext;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.spi.TypeConverterRegistry;

public class TypeConverterRegistryStatisticsEnabledTest
extends ContextTestSupport {
    @Override
    protected CamelContext createCamelContext() throws Exception {
        CamelContext context = super.createCamelContext();
        context.setTypeConverterStatisticsEnabled(Boolean.valueOf(true));
        return context;
    }

    public void testTypeConverterRegistry() throws Exception {
        this.getMockEndpoint("mock:a").expectedMessageCount(2);
        this.template.sendBody("direct:start", (Object)"3");
        this.template.sendBody("direct:start", (Object)"7");
        this.assertMockEndpointsSatisfied();
        TypeConverterRegistry reg = this.context.getTypeConverterRegistry();
        TypeConverterRegistryStatisticsEnabledTest.assertTrue((String)"Should be enabled", (boolean)reg.getStatistics().isStatisticsEnabled());
        Long failed = reg.getStatistics().getFailedCounter();
        TypeConverterRegistryStatisticsEnabledTest.assertEquals((int)0, (int)failed.intValue());
        Long miss = reg.getStatistics().getMissCounter();
        TypeConverterRegistryStatisticsEnabledTest.assertEquals((int)0, (int)miss.intValue());
        try {
            this.template.sendBody("direct:start", (Object)"foo");
            TypeConverterRegistryStatisticsEnabledTest.fail((String)"Should have thrown exception");
        }
        catch (Exception e) {
            // empty catch block
        }
        failed = reg.getStatistics().getFailedCounter();
        TypeConverterRegistryStatisticsEnabledTest.assertEquals((int)1, (int)failed.intValue());
        miss = reg.getStatistics().getMissCounter();
        TypeConverterRegistryStatisticsEnabledTest.assertEquals((int)0, (int)miss.intValue());
        reg.getStatistics().reset();
        failed = reg.getStatistics().getFailedCounter();
        TypeConverterRegistryStatisticsEnabledTest.assertEquals((int)0, (int)failed.intValue());
        miss = reg.getStatistics().getMissCounter();
        TypeConverterRegistryStatisticsEnabledTest.assertEquals((int)0, (int)miss.intValue());
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                ((RouteDefinition)this.from("direct:start").routeId("foo").convertBodyTo(Integer.TYPE)).to("mock:a");
            }
        };
    }
}

