/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.issues;

import java.util.Map;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Endpoint;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.impl.DefaultComponent;
import org.apache.camel.impl.DefaultEndpoint;

public class ComponentUseRawUriTest
extends ContextTestSupport {
    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.context.addComponent("my", (Component)new MyComponent());
    }

    public void testUseRaw() {
        String uri = "my:host:11303/tube1+tube?foo=%2B+tube%3F&bar=++%%w?rd";
        MyEndpoint endpoint = (MyEndpoint)this.context.getEndpoint(uri, MyEndpoint.class);
        ComponentUseRawUriTest.assertNotNull((String)"endpoint", (Object)((Object)endpoint));
        ComponentUseRawUriTest.assertEquals((String)"%2B+tube%3F", (String)endpoint.getFoo());
        ComponentUseRawUriTest.assertEquals((String)"++%%w?rd", (String)endpoint.getBar());
        ComponentUseRawUriTest.assertEquals((String)uri, (String)endpoint.getUri());
    }

    class MyComponent
    extends DefaultComponent {
        MyComponent() {
        }

        protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
            MyEndpoint answer = new MyEndpoint(uri, remaining);
            this.setProperties((Object)answer, parameters);
            return answer;
        }

        public boolean useRawUri() {
            return true;
        }
    }

    public static class MyEndpoint
    extends DefaultEndpoint {
        String uri;
        String remaining;
        String foo;
        String bar;

        public MyEndpoint(String uri, String remaining) {
            this.uri = uri;
            this.remaining = remaining;
        }

        public Producer createProducer() throws Exception {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public Consumer createConsumer(Processor processor) throws Exception {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public String getFoo() {
            return this.foo;
        }

        public void setFoo(String foo) {
            this.foo = foo;
        }

        public String getBar() {
            return this.bar;
        }

        public void setBar(String bar) {
            this.bar = bar;
        }

        public boolean isSingleton() {
            return true;
        }

        public String getUri() {
            return this.uri;
        }
    }
}

