/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.issues;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.ErrorHandlerFactory;
import org.apache.camel.builder.ErrorHandlerBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.RouteDefinition;

public class ErrorHandlerAdviceIssueTest
extends ContextTestSupport {
    public void testErrorHandlerAdvice() throws Exception {
        RouteDefinition foo = this.context.getRouteDefinition("foo");
        foo.adviceWith(this.context, new RouteBuilder(){

            public void configure() throws Exception {
                this.interceptSendToEndpoint("seda:*").skipSendToOriginalEndpoint().throwException((Exception)new IllegalAccessException("Forced"));
            }
        });
        RouteDefinition error = this.context.getRouteDefinition("error");
        error.adviceWith(this.context, new RouteBuilder(){

            public void configure() throws Exception {
                this.interceptSendToEndpoint("file:*").skipSendToOriginalEndpoint().to("mock:file");
            }
        });
        this.getMockEndpoint("mock:error").expectedMessageCount(1);
        this.getMockEndpoint("mock:file").expectedMessageCount(1);
        this.getMockEndpoint("mock:foo").expectedMessageCount(0);
        this.context.stopRoute("timer");
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                this.errorHandler((ErrorHandlerBuilder)this.deadLetterChannel("direct:error").maximumRedeliveries(2).redeliveryDelay(0L));
                ((RouteDefinition)this.from("direct:error").routeId("error").errorHandler((ErrorHandlerFactory)this.deadLetterChannel("log:dead?level=ERROR")).to("mock:error")).to("file:error");
                this.from("timer://someTimer?delay=15000&fixedRate=true&period=5000").routeId("timer").to("log:level=INFO");
                this.from("direct:start").routeId("foo").to("seda:foo");
                this.from("seda:foo").to("mock:foo");
            }
        };
    }
}

