/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.issues;

import java.io.IOException;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.camel.CamelExecutionException;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.OnExceptionDefinition;
import org.apache.camel.model.RouteDefinition;

public class ExceptionThrownFromOnExceptionNoEndlessLoopTest
extends ContextTestSupport {
    private static final AtomicInteger RETRY = new AtomicInteger();
    private static final AtomicInteger ON_EXCEPTION_RETRY = new AtomicInteger();
    private static final AtomicInteger ON_EXCEPTION_2_RETRY = new AtomicInteger();

    @Override
    public boolean isUseRouteBuilder() {
        return false;
    }

    public void testExceptionThrownFromOnExceptionNoEndlessLoopTest() throws Exception {
        RETRY.set(0);
        ON_EXCEPTION_RETRY.set(0);
        ON_EXCEPTION_2_RETRY.set(0);
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() throws Exception {
                ((OnExceptionDefinition)((OnExceptionDefinition)this.onException(IOException.class).maximumRedeliveries(3).to("mock:b")).process(new Processor(){

                    public void process(Exchange exchange) throws Exception {
                        ON_EXCEPTION_RETRY.incrementAndGet();
                        throw new IllegalArgumentException("Not supported");
                    }
                })).to("mock:c");
                ((OnExceptionDefinition)((OnExceptionDefinition)this.onException(IllegalArgumentException.class).to("mock:d")).process(new Processor(){

                    public void process(Exchange exchange) throws Exception {
                        ON_EXCEPTION_2_RETRY.incrementAndGet();
                        throw new IOException("Some other IOException");
                    }
                })).to("mock:e");
                ((RouteDefinition)this.from("direct:start").to("direct:intermediate")).to("mock:result");
                ((RouteDefinition)((RouteDefinition)this.from("direct:intermediate").to("mock:a")).process(new Processor(){

                    public void process(Exchange exchange) throws Exception {
                        RETRY.incrementAndGet();
                        throw new IOException("IO error");
                    }
                })).to("mock:end");
            }
        });
        this.context.start();
        this.getMockEndpoint("mock:a").expectedMessageCount(1);
        this.getMockEndpoint("mock:b").expectedMessageCount(1);
        this.getMockEndpoint("mock:c").expectedMessageCount(0);
        this.getMockEndpoint("mock:d").expectedMessageCount(0);
        this.getMockEndpoint("mock:e").expectedMessageCount(0);
        this.getMockEndpoint("mock:result").expectedMessageCount(0);
        this.getMockEndpoint("mock:end").expectedMessageCount(0);
        try {
            this.template.sendBody("direct:start", (Object)"Hello World");
            ExceptionThrownFromOnExceptionNoEndlessLoopTest.fail((String)"Should have thrown an exception");
        }
        catch (CamelExecutionException e) {
            IllegalArgumentException cause = ExceptionThrownFromOnExceptionNoEndlessLoopTest.assertIsInstanceOf(IllegalArgumentException.class, e.getCause());
            ExceptionThrownFromOnExceptionNoEndlessLoopTest.assertEquals((String)"Not supported", (String)cause.getMessage());
        }
        this.assertMockEndpointsSatisfied();
        ExceptionThrownFromOnExceptionNoEndlessLoopTest.assertEquals((String)"Should try 4 times (1 first, 3 retry)", (int)4, (int)RETRY.get());
        ExceptionThrownFromOnExceptionNoEndlessLoopTest.assertEquals((String)"Should only invoke onException once", (int)1, (int)ON_EXCEPTION_RETRY.get());
        ExceptionThrownFromOnExceptionNoEndlessLoopTest.assertEquals((String)"Should not be invoked", (int)0, (int)ON_EXCEPTION_2_RETRY.get());
    }
}

