/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.issues;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.PollingConsumer;

public class FilePollingConsumerIssueTest
extends ContextTestSupport {
    @Override
    protected void setUp() throws Exception {
        FilePollingConsumerIssueTest.deleteDirectory("target/fpc");
        super.setUp();
    }

    public void testFilePollingConsumer() throws Exception {
        this.template.sendBodyAndHeader("file://target/fpc", (Object)"Hello World", "CamelFileName", (Object)"hello.txt");
        Endpoint endpoint = this.context.getEndpoint("file://target/fpc?fileName=hello.txt");
        PollingConsumer consumer = endpoint.createPollingConsumer();
        consumer.start();
        Exchange exchange = consumer.receive(5000L);
        FilePollingConsumerIssueTest.assertNotNull((Object)exchange);
        FilePollingConsumerIssueTest.assertEquals((String)"hello.txt", (String)((String)exchange.getIn().getHeader("CamelFileName", String.class)));
        FilePollingConsumerIssueTest.assertEquals((String)"Hello World", (String)((String)exchange.getIn().getBody(String.class)));
        consumer.stop();
    }
}

