/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.issues;

import java.io.File;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.activation.FileDataSource;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.Processor;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.RouteDefinition;

public class MessageWithAttachmentRedeliveryIssueTest
extends ContextTestSupport {
    public void testMessageWithAttachmentRedeliveryIssue() throws Exception {
        this.getMockEndpoint("mock:result").expectedMessageCount(1);
        this.template.send("direct:start", new Processor(){

            public void process(Exchange exchange) throws Exception {
                exchange.getIn().setBody((Object)"Hello World");
                exchange.getIn().addAttachment("message1.xml", new DataHandler((DataSource)new FileDataSource(new File("src/test/data/message1.xml"))));
                exchange.getIn().addAttachment("message2.xml", new DataHandler((DataSource)new FileDataSource(new File("src/test/data/message2.xml"))));
            }
        });
        this.assertMockEndpointsSatisfied();
        Message msg = ((Exchange)this.getMockEndpoint("mock:result").getReceivedExchanges().get(0)).getIn();
        MessageWithAttachmentRedeliveryIssueTest.assertNotNull((Object)msg);
        MessageWithAttachmentRedeliveryIssueTest.assertEquals((Object)"Hello World", (Object)msg.getBody());
        MessageWithAttachmentRedeliveryIssueTest.assertTrue((boolean)msg.hasAttachments());
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                this.onException(Exception.class).maximumRedeliveries(3).redeliveryDelay(0L);
                ((RouteDefinition)this.from("direct:start").process(new Processor(){
                    private int counter;

                    public void process(Exchange exchange) throws Exception {
                        if (this.counter++ < 2) {
                            throw new IllegalArgumentException("Forced");
                        }
                    }
                })).to("mock:result");
            }
        };
    }
}

