/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.issues;

import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.Processor;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.issues.MulticastStopOnExceptionWithOnExceptionIssueTest;
import org.apache.camel.model.MulticastDefinition;
import org.apache.camel.model.OnExceptionDefinition;

public class MulticastParallelStopOnExceptionWithOnExceptionIssueTest
extends MulticastStopOnExceptionWithOnExceptionIssueTest {
    @Override
    public void testEnd1FailureTest() throws Exception {
        MockEndpoint end1 = this.getMockEndpoint("mock:end1");
        end1.whenAnyExchangeReceived(new Processor(){

            public void process(Exchange exchange) throws Exception {
                throw new RuntimeException("Simulated Exception");
            }
        });
        this.getMockEndpoint("mock:end2").expectedMinimumMessageCount(0);
        this.getMockEndpoint("mock:end3").expectedMessageCount(0);
        this.getMockEndpoint("mock:end4").expectedMessageCount(1);
        String result = (String)this.template.requestBody("direct:start", (Object)"Hello World!", String.class);
        MulticastParallelStopOnExceptionWithOnExceptionIssueTest.assertEquals((String)"Stop!", (String)result);
        this.assertMockEndpointsSatisfied();
    }

    @Override
    public void testEnd2FailureTest() throws Exception {
        MockEndpoint end2 = this.getMockEndpoint("mock:end2");
        end2.whenAnyExchangeReceived(new Processor(){

            public void process(Exchange exchange) throws Exception {
                throw new RuntimeException("Simulated Exception");
            }
        });
        this.getMockEndpoint("mock:end1").expectedMinimumMessageCount(0);
        this.getMockEndpoint("mock:end3").expectedMessageCount(0);
        this.getMockEndpoint("mock:end4").expectedMessageCount(1);
        String result = (String)this.template.requestBody("direct:start", (Object)"Hello World!", String.class);
        MulticastParallelStopOnExceptionWithOnExceptionIssueTest.assertEquals((String)"Stop!", (String)result);
        this.assertMockEndpointsSatisfied();
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                ((OnExceptionDefinition)((OnExceptionDefinition)this.onException(Exception.class).handled(true).to("log:onException")).to("mock:end4")).transform((Expression)this.constant("Stop!"));
                ((MulticastDefinition)this.from("direct:start").multicast().parallelProcessing().stopOnException().to(new String[]{"mock:end1", "mock:end2"})).end().to("mock:end3").transform((Expression)this.constant("Hello to you too!"));
            }
        };
    }
}

