/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.issues;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.Message;
import org.apache.camel.Processor;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.support.ExpressionAdapter;

public class NeilSplitterTest
extends ContextTestSupport {
    protected Endpoint startEndpoint;
    protected MockEndpoint resultEndpoint;

    public void testCustomExpression() throws Exception {
        this.resultEndpoint.expectedBodiesReceived(new Object[]{"Ginger", "Mr Boots"});
        this.template.send("direct:custom", new Processor(){

            public void process(Exchange exchange) {
                Message in = exchange.getIn();
                CatFight catFight = new CatFight();
                catFight.setName("blueydart");
                catFight.setCats(new String[]{"Ginger", "Mr Boots"});
                in.setBody((Object)catFight);
                in.setHeader("foo", (Object)"bar");
            }
        });
        this.resultEndpoint.assertIsSatisfied();
    }

    public void testXPathExpression() throws Exception {
        this.resultEndpoint.expectedBodiesReceived(new Object[]{"<b>Ginger</b>", "<b>Mr Boots</b>"});
        this.template.send("direct:xpath", new Processor(){

            public void process(Exchange exchange) {
                Message in = exchange.getIn();
                in.setBody((Object)"<a><b>Ginger</b><b>Mr Boots</b></a> ");
                in.setHeader("foo", (Object)"bar");
            }
        });
        this.resultEndpoint.assertIsSatisfied();
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.resultEndpoint = this.getMockEndpoint("mock:result");
    }

    @Override
    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ExpressionAdapter catFightCats = new ExpressionAdapter(){

                    public Object evaluate(Exchange exchange) {
                        CatFight catFight = (CatFight)exchange.getIn().getBody();
                        String[] cats = catFight.getCats();
                        return cats;
                    }
                };
                this.from("direct:custom").split((Expression)catFightCats).to("mock:result");
                this.from("direct:xpath").split((Expression)this.xpath("/a/b")).to("mock:result");
            }
        };
    }

    class CatFight {
        String name;
        String[] cats;

        CatFight() {
        }

        public String[] getCats() {
            return this.cats;
        }

        public void setCats(String[] cats) {
            this.cats = cats;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }
    }
}

