/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.issues;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.Message;
import org.apache.camel.Processor;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.OnExceptionDefinition;
import org.apache.camel.model.RouteDefinition;

public class OnExceptionProcessIssueTest
extends ContextTestSupport {
    public void testOnExceptionProcessIssue() throws Exception {
        Exchange out = this.template.send("direct:start", new Processor(){

            public void process(Exchange exchange) throws Exception {
                exchange.getIn().setBody((Object)"Hello World");
            }
        });
        OnExceptionProcessIssueTest.assertNotNull((Object)out);
        OnExceptionProcessIssueTest.assertEquals((Object)"bar", (Object)out.getIn().getHeader("foo"));
        OnExceptionProcessIssueTest.assertEquals((Object)"ERROR: Damn for message: Hello World", (Object)out.getIn().getBody());
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                ((OnExceptionDefinition)this.onException(Exception.class).useOriginalMessage().handled(true).setHeader("foo", (Expression)this.constant("bar"))).process(new Processor(){

                    public void process(Exchange exchange) throws Exception {
                        Message in = exchange.getIn();
                        Exception ex = (Exception)exchange.getProperty("CamelExceptionCaught", Exception.class);
                        in.setBody((Object)("ERROR: " + ex.getMessage() + " for message: " + in.getBody()));
                    }
                });
                ((RouteDefinition)this.from("direct:start").transform((Expression)this.constant("Bye World"))).throwException((Exception)new IllegalArgumentException("Damn"));
            }
        };
    }
}

