/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.issues;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.impl.JndiRegistry;
import org.apache.camel.model.OnExceptionDefinition;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.model.RouteDefinition;

public class OnExceptionWithTwoBeansTest
extends ContextTestSupport {
    @Override
    protected JndiRegistry createRegistry() throws Exception {
        JndiRegistry registry = new JndiRegistry(this.createJndiContext());
        registry.bind("checkin", (Object)new MyBean1());
        registry.bind("handler", (Object)new MyBean2());
        return registry;
    }

    public void testOnExceptionFirstBean() throws Exception {
        this.getMockEndpoint("mock:error").expectedMessageCount(1);
        this.getMockEndpoint("mock:bean").expectedMessageCount(0);
        this.getMockEndpoint("mock:result").expectedMessageCount(0);
        this.template.sendBody("direct:start", (Object)"illegal");
        this.assertMockEndpointsSatisfied();
    }

    public void testOnExceptionSecondBean() throws Exception {
        this.getMockEndpoint("mock:error").expectedMessageCount(1);
        this.getMockEndpoint("mock:bean").expectedMessageCount(1);
        this.getMockEndpoint("mock:result").expectedMessageCount(0);
        this.template.sendBody("direct:start", (Object)"handle");
        this.assertMockEndpointsSatisfied();
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                ((OnExceptionDefinition)((ProcessorDefinition)this.onException(IllegalArgumentException.class).handled(true).setBody().constant((Object)"Handled")).to("mock:error")).end();
                ((RouteDefinition)((RouteDefinition)((RouteDefinition)this.from("direct:start").unmarshal().string().to("bean:checkin")).to("mock:bean")).to("bean:handler")).to("mock:result");
            }
        };
    }

    public class MyBean2 {
        public String handle(String message) {
            if ("handle".equals(message)) {
                throw new IllegalArgumentException();
            }
            return message;
        }
    }

    public class MyBean1 {
        public String checkin(String message) {
            if ("illegal".equals(message)) {
                throw new IllegalArgumentException();
            }
            return message;
        }
    }
}

