/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.issues;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.Processor;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.builder.ValueBuilder;
import org.apache.camel.model.RouteDefinition;

public class RecipientListErrorHandlingIssueTest
extends ContextTestSupport {
    @Override
    public boolean isUseRouteBuilder() {
        return false;
    }

    public void testUsingInterceptor() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() throws Exception {
                this.onException(Exception.class).handled(true).to("mock:error");
                this.interceptSendToEndpoint("direct:*").process(new Processor(){

                    public void process(Exchange exchange) throws Exception {
                        String target = (String)exchange.getIn().getHeader("CamelInterceptedEndpoint", String.class);
                        exchange.getIn().setHeader("target", (Object)target);
                    }
                });
                this.from("direct:start").recipientList((Expression)this.header("foo"));
                ((RouteDefinition)this.from("direct:foo").setBody((Expression)this.constant("Bye World"))).to("mock:foo");
                this.from("direct:kabom").throwException((Exception)new IllegalArgumentException("Damn"));
            }
        });
        this.context.start();
        this.getMockEndpoint("mock:foo").expectedMessageCount(1);
        this.getMockEndpoint("mock:error").expectedMessageCount(1);
        ((ValueBuilder)this.getMockEndpoint("mock:error").message(0).header("target")).isEqualTo((Object)"direct://kabom");
        String foo = "direct:foo,direct:kabom";
        this.template.sendBodyAndHeader("direct:start", (Object)"Hello World", "foo", (Object)foo);
        this.assertMockEndpointsSatisfied();
    }

    public void testUsingExistingHeaders() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() throws Exception {
                this.onException(Exception.class).handled(true).to("mock:error");
                this.from("direct:start").recipientList((Expression)this.header("foo"));
                ((RouteDefinition)this.from("direct:foo").setBody((Expression)this.constant("Bye World"))).to("mock:foo");
                this.from("direct:kabom").throwException((Exception)new IllegalArgumentException("Damn"));
            }
        });
        this.context.start();
        this.getMockEndpoint("mock:foo").expectedMessageCount(1);
        ((ValueBuilder)this.getMockEndpoint("mock:foo").message(0).header("CamelToEndpoint")).isEqualTo((Object)"mock://foo");
        this.getMockEndpoint("mock:error").expectedMessageCount(1);
        ((ValueBuilder)this.getMockEndpoint("mock:error").message(0).header("CamelFailureEndpoint")).isEqualTo((Object)"direct://kabom");
        String foo = "direct:foo,direct:kabom";
        this.template.sendBodyAndHeader("direct:start", (Object)"Hello World", "foo", (Object)foo);
        this.assertMockEndpointsSatisfied();
    }
}

