/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.language;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.Expression;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.impl.JndiRegistry;
import org.apache.camel.language.Bean;
import org.apache.camel.model.RouteDefinition;

public class BeanAnnotationParameterTwoTest
extends ContextTestSupport {
    public void testBeanAnnotationOne() throws Exception {
        this.getMockEndpoint("mock:result").expectedBodiesReceived(new Object[]{"Hello/Bonjour World"});
        this.template.sendBody("direct:one", (Object)"World");
        this.assertMockEndpointsSatisfied();
    }

    public void testBeanAnnotationTwo() throws Exception {
        this.getMockEndpoint("mock:result").expectedBodiesReceived(new Object[]{"Hello/Bonjour World"});
        this.template.sendBody("direct:two", (Object)"World");
        this.assertMockEndpointsSatisfied();
    }

    public void testBeanAnnotationThree() throws Exception {
        this.getMockEndpoint("mock:result").expectedBodiesReceived(new Object[]{"Hello/Bonjour World"});
        this.template.sendBody("direct:three", (Object)"World");
        this.assertMockEndpointsSatisfied();
    }

    public void testBeanAnnotationFour() throws Exception {
        this.getMockEndpoint("mock:middle").expectedBodiesReceived(new Object[]{"Hello/Bonjour World"});
        this.getMockEndpoint("mock:result").expectedBodiesReceived(new Object[]{"Bye World"});
        this.template.sendBody("direct:four", (Object)"World");
        this.assertMockEndpointsSatisfied();
    }

    @Override
    protected JndiRegistry createRegistry() throws Exception {
        JndiRegistry jndi = super.createRegistry();
        jndi.bind("GreetingService", (Object)new GreetingService());
        return jndi;
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                ((RouteDefinition)this.from("direct:one").bean(MyBean.class)).to("mock:result");
                ((RouteDefinition)this.from("direct:two").bean(MyBean.class, "callA")).to("mock:result");
                ((RouteDefinition)((RouteDefinition)this.from("direct:three").setHeader("CamelBeanMethodName", (Expression)this.constant("callA"))).bean(MyBean.class)).to("mock:result");
                ((RouteDefinition)((RouteDefinition)((RouteDefinition)this.from("direct:four").bean(MyBean.class, "callA")).to("mock:middle")).bean(MyBean.class, "callB")).to("mock:result");
            }
        };
    }

    public static final class GreetingService {
        public String callA() {
            throw new IllegalArgumentException("Should not callA");
        }

        public String callB() {
            throw new IllegalArgumentException("Should not callB");
        }

        public String english() {
            return "Hello";
        }

        public String french() {
            return "Bonjour";
        }

        public String german() {
            return "Hallo";
        }
    }

    public static final class MyBean {
        public String callA(@Bean(ref="GreetingService", method="english") String greeting, @Bean(ref="GreetingService", method="french") String french, String body) {
            return greeting + "/" + french + " " + body;
        }

        public String callB() {
            return "Bye World";
        }
    }
}

