/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.language;

import org.apache.camel.Exchange;
import org.apache.camel.LanguageTestSupport;
import org.apache.camel.impl.JndiRegistry;
import org.apache.camel.support.ExpressionAdapter;

public class RefTest
extends LanguageTestSupport {
    @Override
    protected JndiRegistry createRegistry() throws Exception {
        JndiRegistry jndi = super.createRegistry();
        jndi.bind("myExp", (Object)new MyExpression());
        return jndi;
    }

    public void testRefExpressions() throws Exception {
        this.assertExpression("myExp", "Hello World");
    }

    public void testRefExpressionsNotFound() throws Exception {
        try {
            this.assertExpression("foo", "Hello World");
            RefTest.fail((String)"Should have thrown exception");
        }
        catch (IllegalArgumentException e) {
            RefTest.assertEquals((String)"Cannot find expression in registry with ref: foo", (String)e.getMessage());
        }
    }

    public void testPredicates() throws Exception {
        this.assertPredicate("myExp");
    }

    @Override
    protected String getLanguageName() {
        return "ref";
    }

    private static class MyExpression
    extends ExpressionAdapter {
        private MyExpression() {
        }

        public Object evaluate(Exchange exchange) {
            return "Hello World";
        }
    }
}

