/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.language;

import java.io.File;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.ChoiceDefinition;

public class TokenPairPredicateTest
extends ContextTestSupport {
    @Override
    protected void setUp() throws Exception {
        TokenPairPredicateTest.deleteDirectory("target/pair");
        super.setUp();
    }

    public void testTokenPairPredicate() throws Exception {
        this.getMockEndpoint("mock:result").expectedMessageCount(1);
        this.template.sendBodyAndHeader("file:target/pair", (Object)"<hello>world!</hello>", "CamelFileName", (Object)"hello.xml");
        this.assertMockEndpointsSatisfied();
        this.oneExchangeDone.matchesMockWaitTime();
        File file = new File("target/pair/hello.xml");
        TokenPairPredicateTest.assertFalse((String)("File should not exists " + file), (boolean)file.exists());
        file = new File("target/pair/ok/hello.xml");
        TokenPairPredicateTest.assertTrue((String)("File should exists " + file), (boolean)file.exists());
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                ((ChoiceDefinition)((ChoiceDefinition)this.from("file:target/pair?move=ok").choice().when().tokenizePair("<hello>", "</hello>")).to("mock:result")).end();
            }
        };
    }
}

