/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.language;

import java.io.File;
import java.io.FileOutputStream;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import junit.framework.TestCase;
import org.apache.camel.CamelContext;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.builder.NotifyBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.ChoiceDefinition;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.model.SplitDefinition;
import org.apache.camel.util.StopWatch;
import org.apache.camel.util.TimeUtils;
import org.slf4j.Logger;

public class XPathSplitChoicePerformanceTest
extends ContextTestSupport {
    private int size = 20000;
    private final AtomicInteger tiny = new AtomicInteger();
    private final AtomicInteger small = new AtomicInteger();
    private final AtomicInteger med = new AtomicInteger();
    private final AtomicInteger large = new AtomicInteger();
    private final StopWatch watch = new StopWatch();

    @Override
    public void setUp() throws Exception {
        XPathSplitChoicePerformanceTest.createDataFile(this.log, this.size);
        super.setUp();
    }

    public void testDummy() {
    }

    public void xxTestXPatPerformanceRoute() throws Exception {
        NotifyBuilder notify = new NotifyBuilder((CamelContext)this.context).whenDone(this.size).create();
        boolean matches = notify.matches(60L, TimeUnit.SECONDS);
        this.log.info("Processed file with " + this.size + " elements in: " + TimeUtils.printDuration((double)this.watch.stop()));
        this.log.info("Processed " + this.tiny.get() + " tiny messages");
        this.log.info("Processed " + this.small.get() + " small messages");
        this.log.info("Processed " + this.med.get() + " medium messages");
        this.log.info("Processed " + this.large.get() + " large messages");
        XPathSplitChoicePerformanceTest.assertEquals((int)(this.size / 10 * 4), (int)this.tiny.get());
        XPathSplitChoicePerformanceTest.assertEquals((int)(this.size / 10 * 2), (int)this.small.get());
        XPathSplitChoicePerformanceTest.assertEquals((int)(this.size / 10 * 3), (int)this.med.get());
        XPathSplitChoicePerformanceTest.assertEquals((int)(this.size / 10 * 1), (int)this.large.get());
        XPathSplitChoicePerformanceTest.assertTrue((String)"Should complete route", (boolean)matches);
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                ((ChoiceDefinition)((ChoiceDefinition)((ChoiceDefinition)((ChoiceDefinition)((ChoiceDefinition)((ChoiceDefinition)((ChoiceDefinition)((SplitDefinition)((RouteDefinition)this.from("file:target/data?noop=true").process(new Processor(){

                    public void process(Exchange exchange) throws Exception {
                        log.info("Starting to process file");
                        XPathSplitChoicePerformanceTest.this.watch.restart();
                    }
                })).split().xpath("/orders/order")).streaming().choice().when().xpath("/order/amount < 10")).process(new Processor(){

                    public void process(Exchange exchange) throws Exception {
                        String xml = (String)exchange.getIn().getBody(String.class);
                        TestCase.assertTrue((String)xml, (boolean)xml.contains("<amount>3</amount>"));
                        int num = XPathSplitChoicePerformanceTest.this.tiny.incrementAndGet();
                        if (num % 100 == 0) {
                            log.info("Processed " + num + " tiny messages");
                            log.debug(xml);
                        }
                    }
                })).when().xpath("/order/amount < 50")).process(new Processor(){

                    public void process(Exchange exchange) throws Exception {
                        String xml = (String)exchange.getIn().getBody(String.class);
                        TestCase.assertTrue((String)xml, (boolean)xml.contains("<amount>44</amount>"));
                        int num = XPathSplitChoicePerformanceTest.this.small.incrementAndGet();
                        if (num % 100 == 0) {
                            log.info("Processed " + num + " small messages");
                            log.debug(xml);
                        }
                    }
                })).when().xpath("/order/amount < 100")).process(new Processor(){

                    public void process(Exchange exchange) throws Exception {
                        String xml = (String)exchange.getIn().getBody(String.class);
                        TestCase.assertTrue((String)xml, (boolean)xml.contains("<amount>88</amount>"));
                        int num = XPathSplitChoicePerformanceTest.this.med.incrementAndGet();
                        if (num % 100 == 0) {
                            log.info("Processed " + num + " medium messages");
                            log.debug(xml);
                        }
                    }
                })).otherwise().process(new Processor(){

                    public void process(Exchange exchange) throws Exception {
                        String xml = (String)exchange.getIn().getBody(String.class);
                        TestCase.assertTrue((String)xml, (boolean)xml.contains("<amount>123</amount>"));
                        int num = XPathSplitChoicePerformanceTest.this.large.incrementAndGet();
                        if (num % 100 == 0) {
                            log.info("Processed " + num + " large messages");
                            log.debug(xml);
                        }
                    }
                })).end().end();
            }
        };
    }

    public static void createDataFile(Logger log, int size) throws Exception {
        XPathSplitChoicePerformanceTest.deleteDirectory("target/data");
        XPathSplitChoicePerformanceTest.createDirectory("target/data");
        log.info("Creating data file ...");
        File file = new File("target/data/data.xml");
        FileOutputStream fos = new FileOutputStream(file, true);
        fos.write("<orders>\n".getBytes());
        for (int i = 0; i < size; ++i) {
            fos.write("<order>\n".getBytes());
            fos.write(("  <id>" + i + "</id>\n").getBytes());
            int num = i % 10;
            if (num >= 0 && num <= 3) {
                fos.write("  <amount>3</amount>\n".getBytes());
                fos.write("  <customerId>333</customerId>\n".getBytes());
            } else if (num >= 4 && num <= 5) {
                fos.write("  <amount>44</amount>\n".getBytes());
                fos.write("  <customerId>444</customerId>\n".getBytes());
            } else if (num >= 6 && num <= 8) {
                fos.write("  <amount>88</amount>\n".getBytes());
                fos.write("  <customerId>888</customerId>\n".getBytes());
            } else {
                fos.write("  <amount>123</amount>\n".getBytes());
                fos.write("  <customerId>123123</customerId>\n".getBytes());
            }
            fos.write("  <description>bla bla bla bla bla bla bla bla bla bla bla bla bla bla bla bla</description>\n".getBytes());
            fos.write("</order>\n".getBytes());
        }
        fos.write("</orders>".getBytes());
        fos.close();
        log.info("Creating data file done.");
    }
}

