/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.main;

import java.util.Date;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.main.Main;
import org.apache.camel.model.RouteDefinition;

public class MainExample {
    private Main main;

    public static void main(String[] args) throws Exception {
        MainExample example = new MainExample();
        example.boot();
    }

    public void boot() throws Exception {
        this.main = new Main();
        this.main.enableHangupSupport();
        this.main.bind("foo", (Object)new MyBean());
        this.main.addRouteBuilder((RouteBuilder)new MyRouteBuilder());
        System.out.println("Starting Camel. Use ctrl + c to terminate the JVM.\n");
        this.main.run();
    }

    public static class MyBean {
        public void callMe() {
            System.out.println("MyBean.calleMe method has been called");
        }
    }

    private static class MyRouteBuilder
    extends RouteBuilder {
        private MyRouteBuilder() {
        }

        public void configure() throws Exception {
            ((RouteDefinition)this.from("timer:foo?delay=2000").process(new Processor(){

                public void process(Exchange exchange) throws Exception {
                    System.out.println("Invoked timer at " + new Date());
                }
            })).beanRef("foo");
        }
    }
}

