/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management;

import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.management.ManagementTestSupport;
import org.apache.camel.model.ThreadsDefinition;

public class DualManagedThreadPoolWithIdTest
extends ManagementTestSupport {
    public void testManagedThreadPool() throws Exception {
        if (DualManagedThreadPoolWithIdTest.isPlatform("aix")) {
            return;
        }
        MBeanServer mbeanServer = this.getMBeanServer();
        ObjectName on = ObjectName.getInstance("org.apache.camel:context=camel-1,type=threadpools,name=\"myThreads(threads)\"");
        Integer corePoolSize = (Integer)mbeanServer.getAttribute(on, "CorePoolSize");
        DualManagedThreadPoolWithIdTest.assertEquals((int)15, (int)corePoolSize);
        Integer maxPoolSize = (Integer)mbeanServer.getAttribute(on, "MaximumPoolSize");
        DualManagedThreadPoolWithIdTest.assertEquals((int)30, (int)maxPoolSize);
        String id = (String)mbeanServer.getAttribute(on, "Id");
        DualManagedThreadPoolWithIdTest.assertEquals((String)"myThreads", (String)id);
        String source = (String)mbeanServer.getAttribute(on, "SourceId");
        DualManagedThreadPoolWithIdTest.assertEquals((String)"threads", (String)source);
        String route = (String)mbeanServer.getAttribute(on, "RouteId");
        DualManagedThreadPoolWithIdTest.assertEquals((String)"route1", (String)route);
        on = ObjectName.getInstance("org.apache.camel:context=camel-1,type=threadpools,name=\"myOtherThreads(threads)\"");
        corePoolSize = (Integer)mbeanServer.getAttribute(on, "CorePoolSize");
        DualManagedThreadPoolWithIdTest.assertEquals((int)1, (int)corePoolSize);
        maxPoolSize = (Integer)mbeanServer.getAttribute(on, "MaximumPoolSize");
        DualManagedThreadPoolWithIdTest.assertEquals((int)2, (int)maxPoolSize);
        id = (String)mbeanServer.getAttribute(on, "Id");
        DualManagedThreadPoolWithIdTest.assertEquals((String)"myOtherThreads", (String)id);
        source = (String)mbeanServer.getAttribute(on, "SourceId");
        DualManagedThreadPoolWithIdTest.assertEquals((String)"threads", (String)source);
        route = (String)mbeanServer.getAttribute(on, "RouteId");
        DualManagedThreadPoolWithIdTest.assertEquals((String)"route2", (String)route);
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                ((ThreadsDefinition)this.from("direct:start").threads(15, 30).id("myThreads")).to("mock:result");
                ((ThreadsDefinition)this.from("direct:foo").threads(1, 2).id("myOtherThreads")).to("mock:foo");
            }
        };
    }
}

