/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management;

import java.util.ArrayList;
import java.util.Set;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.management.openmbean.TabularData;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.management.ManagementTestSupport;

public class ManagedEndpointRegistryTest
extends ManagementTestSupport {
    public void testManageEndpointRegistry() throws Exception {
        if (ManagedEndpointRegistryTest.isPlatform("aix")) {
            return;
        }
        this.getMockEndpoint("mock:result").expectedMessageCount(1);
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
        this.template.sendBody("log:foo", (Object)"Hello World");
        MBeanServer mbeanServer = this.getMBeanServer();
        Set<ObjectName> set = mbeanServer.queryNames(new ObjectName("*:type=services,*"), null);
        ArrayList<ObjectName> list = new ArrayList<ObjectName>(set);
        ObjectName on = null;
        for (ObjectName name : list) {
            if (!name.getCanonicalName().contains("DefaultEndpointRegistry")) continue;
            on = name;
            break;
        }
        ManagedEndpointRegistryTest.assertNotNull((String)"Should have found EndpointRegistry", on);
        Integer max = (Integer)mbeanServer.getAttribute(on, "MaximumCacheSize");
        ManagedEndpointRegistryTest.assertEquals((int)1000, (int)max);
        Integer current = (Integer)mbeanServer.getAttribute(on, "Size");
        ManagedEndpointRegistryTest.assertEquals((int)3, (int)current);
        current = (Integer)mbeanServer.getAttribute(on, "StaticSize");
        ManagedEndpointRegistryTest.assertEquals((int)2, (int)current);
        current = (Integer)mbeanServer.getAttribute(on, "DynamicSize");
        ManagedEndpointRegistryTest.assertEquals((int)1, (int)current);
        String source = (String)mbeanServer.getAttribute(on, "Source");
        ManagedEndpointRegistryTest.assertTrue((boolean)source.startsWith("EndpointRegistry"));
        ManagedEndpointRegistryTest.assertTrue((boolean)source.endsWith("capacity: 1000"));
        TabularData data = (TabularData)mbeanServer.invoke(on, "listEndpoints", null, null);
        ManagedEndpointRegistryTest.assertEquals((int)3, (int)data.size());
        mbeanServer.invoke(on, "purge", null, null);
        current = (Integer)mbeanServer.getAttribute(on, "DynamicSize");
        ManagedEndpointRegistryTest.assertEquals((int)0, (int)current);
        current = (Integer)mbeanServer.getAttribute(on, "StaticSize");
        ManagedEndpointRegistryTest.assertEquals((int)2, (int)current);
        current = (Integer)mbeanServer.getAttribute(on, "Size");
        ManagedEndpointRegistryTest.assertEquals((int)2, (int)current);
        data = (TabularData)mbeanServer.invoke(on, "listEndpoints", null, null);
        ManagedEndpointRegistryTest.assertEquals((int)2, (int)data.size());
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                this.from("direct:start").to("mock:result");
            }
        };
    }
}

