/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management;

import java.util.Set;
import javax.management.Attribute;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.camel.CamelExecutionException;
import org.apache.camel.Exchange;
import org.apache.camel.LoggingLevel;
import org.apache.camel.Processor;
import org.apache.camel.builder.ErrorHandlerBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.management.ManagementTestSupport;
import org.apache.camel.model.RouteDefinition;

public class ManagedErrorHandlerOptionsTest
extends ManagementTestSupport {
    private static int counter;

    public void testManagedErrorHandlerOptions() throws Exception {
        if (ManagedErrorHandlerOptionsTest.isPlatform("aix")) {
            return;
        }
        counter = 0;
        MBeanServer mbeanServer = this.getMBeanServer();
        Set<ObjectName> set = mbeanServer.queryNames(new ObjectName("*:type=errorhandlers,*"), null);
        ManagedErrorHandlerOptionsTest.assertEquals((int)1, (int)set.size());
        ObjectName on = set.iterator().next();
        mbeanServer.setAttribute(on, new Attribute("MaximumRedeliveries", 3));
        Integer max = (Integer)mbeanServer.getAttribute(on, "MaximumRedeliveries");
        ManagedErrorHandlerOptionsTest.assertEquals((int)3, (int)max);
        mbeanServer.setAttribute(on, new Attribute("MaximumRedeliveryDelay", Long.valueOf("20000")));
        Long delay = (Long)mbeanServer.getAttribute(on, "MaximumRedeliveryDelay");
        ManagedErrorHandlerOptionsTest.assertEquals((long)20000L, (long)delay);
        mbeanServer.setAttribute(on, new Attribute("RedeliveryDelay", Long.valueOf("250")));
        delay = (Long)mbeanServer.getAttribute(on, "RedeliveryDelay");
        ManagedErrorHandlerOptionsTest.assertEquals((long)250L, (long)delay);
        String camelId = (String)mbeanServer.getAttribute(on, "CamelId");
        ManagedErrorHandlerOptionsTest.assertEquals((String)"camel-1", (String)camelId);
        mbeanServer.setAttribute(on, new Attribute("BackOffMultiplier", Double.valueOf("3.5")));
        Double backoff = (Double)mbeanServer.getAttribute(on, "BackOffMultiplier");
        ManagedErrorHandlerOptionsTest.assertNotNull((Object)backoff);
        mbeanServer.setAttribute(on, new Attribute("CollisionAvoidanceFactor", Double.valueOf("1.5")));
        Double cf = (Double)mbeanServer.getAttribute(on, "CollisionAvoidanceFactor");
        ManagedErrorHandlerOptionsTest.assertNotNull((Object)cf);
        mbeanServer.setAttribute(on, new Attribute("CollisionAvoidancePercent", Double.valueOf("75")));
        Double cp = (Double)mbeanServer.getAttribute(on, "CollisionAvoidancePercent");
        ManagedErrorHandlerOptionsTest.assertNotNull((Object)cp);
        mbeanServer.setAttribute(on, new Attribute("DelayPattern", "0:1000;5:5000"));
        String dp = (String)mbeanServer.getAttribute(on, "DelayPattern");
        ManagedErrorHandlerOptionsTest.assertNotNull((Object)dp);
        mbeanServer.setAttribute(on, new Attribute("RetriesExhaustedLogLevel", "WARN"));
        String ell = (String)mbeanServer.getAttribute(on, "RetriesExhaustedLogLevel");
        ManagedErrorHandlerOptionsTest.assertEquals((String)LoggingLevel.WARN.name(), (String)ell);
        mbeanServer.setAttribute(on, new Attribute("RetryAttemptedLogLevel", "WARN"));
        String rll = (String)mbeanServer.getAttribute(on, "RetryAttemptedLogLevel");
        ManagedErrorHandlerOptionsTest.assertEquals((String)LoggingLevel.WARN.name(), (String)rll);
        mbeanServer.setAttribute(on, new Attribute("LogStackTrace", Boolean.TRUE));
        Boolean lst = (Boolean)mbeanServer.getAttribute(on, "LogStackTrace");
        ManagedErrorHandlerOptionsTest.assertEquals((boolean)true, (boolean)lst);
        mbeanServer.setAttribute(on, new Attribute("UseCollisionAvoidance", Boolean.TRUE));
        Boolean uca = (Boolean)mbeanServer.getAttribute(on, "UseCollisionAvoidance");
        ManagedErrorHandlerOptionsTest.assertEquals((boolean)true, (boolean)uca);
        mbeanServer.setAttribute(on, new Attribute("UseExponentialBackOff", Boolean.TRUE));
        Boolean uebf = (Boolean)mbeanServer.getAttribute(on, "UseExponentialBackOff");
        ManagedErrorHandlerOptionsTest.assertEquals((boolean)true, (boolean)uebf);
        Boolean ne = (Boolean)mbeanServer.getAttribute(on, "DeadLetterHandleNewException");
        ManagedErrorHandlerOptionsTest.assertEquals((boolean)false, (boolean)ne);
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedMessageCount(1);
        this.template.sendBody("direct:start", (Object)"Hello World");
        ManagedErrorHandlerOptionsTest.assertEquals((int)3, (int)counter);
        this.assertMockEndpointsSatisfied();
        counter = 0;
        mock.reset();
        mock.expectedMessageCount(0);
        mbeanServer.setAttribute(on, new Attribute("MaximumRedeliveries", 0));
        try {
            this.template.sendBody("direct:start", (Object)"Bye World");
            ManagedErrorHandlerOptionsTest.fail((String)"Should have thrown exception");
        }
        catch (CamelExecutionException e) {
            IllegalArgumentException cause = ManagedErrorHandlerOptionsTest.assertIsInstanceOf(IllegalArgumentException.class, e.getCause());
            ManagedErrorHandlerOptionsTest.assertEquals((String)"Forced", (String)cause.getMessage());
        }
        ManagedErrorHandlerOptionsTest.assertEquals((int)1, (int)counter);
        max = (Integer)mbeanServer.getAttribute(on, "MaximumRedeliveries");
        ManagedErrorHandlerOptionsTest.assertEquals((int)0, (int)max);
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                this.errorHandler((ErrorHandlerBuilder)this.defaultErrorHandler().maximumRedeliveries(5));
                ((RouteDefinition)this.from("direct:start").process(new Processor(){

                    public void process(Exchange exchange) throws Exception {
                        counter++;
                        if (counter < 3) {
                            throw new IllegalArgumentException("Forced");
                        }
                    }
                })).to("mock:result");
            }
        };
    }
}

