/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management;

import java.io.File;
import java.util.Set;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.Message;
import org.apache.camel.Processor;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.management.ManagementTestSupport;
import org.apache.camel.processor.idempotent.FileIdempotentRepository;
import org.apache.camel.spi.IdempotentRepository;
import org.apache.camel.util.FileUtil;

public class ManagedFileIdempotentConsumerTest
extends ManagementTestSupport {
    protected Endpoint startEndpoint;
    protected MockEndpoint resultEndpoint;
    private File store = new File("target/idempotentfilestore.dat");
    private IdempotentRepository<String> repo;

    public void testDuplicateMessagesAreFilteredOut() throws Exception {
        if (ManagedFileIdempotentConsumerTest.isPlatform("aix")) {
            return;
        }
        MBeanServer mbeanServer = this.getMBeanServer();
        Set<ObjectName> names = mbeanServer.queryNames(new ObjectName("org.apache.camel:type=services,*"), null);
        ObjectName on = null;
        for (ObjectName name : names) {
            if (!name.toString().contains("FileIdempotentRepository")) continue;
            on = name;
            break;
        }
        ManagedFileIdempotentConsumerTest.assertTrue((String)"Should be registered", (boolean)mbeanServer.isRegistered(on));
        String path = (String)mbeanServer.getAttribute(on, "FilePath");
        ManagedFileIdempotentConsumerTest.assertEquals((String)FileUtil.normalizePath((String)"target/idempotentfilestore.dat"), (String)FileUtil.normalizePath((String)path));
        Integer size = (Integer)mbeanServer.getAttribute(on, "CacheSize");
        ManagedFileIdempotentConsumerTest.assertEquals((int)1, (int)size);
        ManagedFileIdempotentConsumerTest.assertFalse((boolean)this.repo.contains((Object)"1"));
        ManagedFileIdempotentConsumerTest.assertFalse((boolean)this.repo.contains((Object)"2"));
        ManagedFileIdempotentConsumerTest.assertFalse((boolean)this.repo.contains((Object)"3"));
        ManagedFileIdempotentConsumerTest.assertTrue((boolean)this.repo.contains((Object)"4"));
        this.resultEndpoint.expectedBodiesReceived(new Object[]{"one", "two", "three"});
        this.sendMessage("1", "one");
        this.sendMessage("2", "two");
        this.sendMessage("1", "one");
        this.sendMessage("2", "two");
        this.sendMessage("4", "four");
        this.sendMessage("1", "one");
        this.sendMessage("3", "three");
        this.resultEndpoint.assertIsSatisfied();
        ManagedFileIdempotentConsumerTest.assertTrue((boolean)this.repo.contains((Object)"1"));
        ManagedFileIdempotentConsumerTest.assertTrue((boolean)this.repo.contains((Object)"2"));
        ManagedFileIdempotentConsumerTest.assertTrue((boolean)this.repo.contains((Object)"3"));
        ManagedFileIdempotentConsumerTest.assertTrue((boolean)this.repo.contains((Object)"4"));
        size = (Integer)mbeanServer.getAttribute(on, "CacheSize");
        ManagedFileIdempotentConsumerTest.assertEquals((int)4, (int)size);
        mbeanServer.invoke(on, "remove", new Object[]{"1"}, new String[]{"java.lang.String"});
        mbeanServer.invoke(on, "reset", null, null);
        size = (Integer)mbeanServer.getAttribute(on, "CacheSize");
        ManagedFileIdempotentConsumerTest.assertEquals((int)3, (int)size);
        ManagedFileIdempotentConsumerTest.assertFalse((boolean)this.repo.contains((Object)"1"));
        ManagedFileIdempotentConsumerTest.assertTrue((boolean)this.repo.contains((Object)"2"));
        ManagedFileIdempotentConsumerTest.assertTrue((boolean)this.repo.contains((Object)"3"));
        ManagedFileIdempotentConsumerTest.assertTrue((boolean)this.repo.contains((Object)"4"));
    }

    protected void sendMessage(final Object messageId, final Object body) {
        this.template.send(this.startEndpoint, new Processor(){

            public void process(Exchange exchange) {
                Message in = exchange.getIn();
                in.setBody(body);
                in.setHeader("messageId", messageId);
            }
        });
    }

    @Override
    protected void setUp() throws Exception {
        if (this.store.exists()) {
            this.store.delete();
        }
        this.repo = FileIdempotentRepository.fileIdempotentRepository((File)this.store);
        this.repo.add((Object)"4");
        super.setUp();
        this.startEndpoint = this.resolveMandatoryEndpoint("direct:start");
        this.resultEndpoint = this.getMockEndpoint("mock:result");
    }

    @Override
    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                this.from("direct:start").idempotentConsumer((Expression)this.header("messageId"), ManagedFileIdempotentConsumerTest.this.repo).to("mock:result");
            }
        };
    }
}

