/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management;

import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.management.openmbean.TabularData;
import junit.framework.TestCase;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.management.ManagementTestSupport;
import org.apache.camel.model.RouteDefinition;

public class ManagedInflightRepositoryTest
extends ManagementTestSupport {
    public void testInflightRepository() throws Exception {
        if (ManagedInflightRepositoryTest.isPlatform("aix")) {
            return;
        }
        this.getMockEndpoint("mock:result").expectedMessageCount(1);
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                ((RouteDefinition)((RouteDefinition)((RouteDefinition)this.from("direct:start").routeId("foo").to("mock:a")).process(new Processor(){

                    public void process(Exchange exchange) throws Exception {
                        MBeanServer mbeanServer = ManagedInflightRepositoryTest.this.getMBeanServer();
                        ObjectName name = ObjectName.getInstance("org.apache.camel:context=camel-1,type=services,name=DefaultInflightRepository");
                        Integer size = (Integer)mbeanServer.getAttribute(name, "Size");
                        TestCase.assertEquals((int)1, (int)size);
                        Integer routeSize = (Integer)mbeanServer.invoke(name, "size", new Object[]{"foo"}, new String[]{"java.lang.String"});
                        TestCase.assertEquals((int)1, (int)routeSize);
                        TabularData data = (TabularData)mbeanServer.invoke(name, "browse", null, null);
                        TestCase.assertNotNull((Object)data);
                        TestCase.assertEquals((int)1, (int)data.size());
                    }
                })).id("myProcessor")).to("mock:result");
            }
        };
    }
}

