/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management;

import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.camel.CamelContext;
import org.apache.camel.ServiceStatus;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.impl.DefaultCamelContext;
import org.apache.camel.impl.SimpleRegistry;
import org.apache.camel.management.ManagementTestSupport;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.spi.Registry;

public class ManagedRefProducerTest
extends ManagementTestSupport {
    private Map registry = new SimpleRegistry();

    @Override
    protected CamelContext createCamelContext() throws Exception {
        DefaultCamelContext context = new DefaultCamelContext((Registry)this.registry);
        this.registry.put("foo", new MockEndpoint("mock://foo"));
        return context;
    }

    public void testProducer() throws Exception {
        String uri;
        boolean registered;
        ObjectName on;
        int i;
        if (ManagedRefProducerTest.isPlatform("aix")) {
            return;
        }
        this.getMockEndpoint("mock:result").expectedMessageCount(1);
        this.getMockEndpoint("foo").expectedMessageCount(1);
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
        MBeanServer mbeanServer = this.getMBeanServer();
        Set<ObjectName> set = mbeanServer.queryNames(new ObjectName("*:type=producers,*"), null);
        ManagedRefProducerTest.assertEquals((int)2, (int)set.size());
        Iterator<ObjectName> it = set.iterator();
        for (i = 0; i < 2; ++i) {
            on = it.next();
            registered = mbeanServer.isRegistered(on);
            ManagedRefProducerTest.assertEquals((String)"Should be registered", (boolean)true, (boolean)registered);
            uri = (String)mbeanServer.getAttribute(on, "EndpointUri");
            ManagedRefProducerTest.assertTrue((String)uri, (uri.equals("mock://foo") || uri.equals("mock://result") ? 1 : 0) != 0);
            String state = (String)mbeanServer.getAttribute(on, "State");
            ManagedRefProducerTest.assertEquals((String)"Should be started", (String)ServiceStatus.Started.name(), (String)state);
        }
        set = mbeanServer.queryNames(new ObjectName("*:type=endpoints,*"), null);
        ManagedRefProducerTest.assertEquals((int)4, (int)set.size());
        it = set.iterator();
        for (i = 0; i < 4; ++i) {
            on = it.next();
            registered = mbeanServer.isRegistered(on);
            ManagedRefProducerTest.assertEquals((String)"Should be registered", (boolean)true, (boolean)registered);
            uri = (String)mbeanServer.getAttribute(on, "EndpointUri");
            ManagedRefProducerTest.assertTrue((String)uri, (uri.equals("direct://start") || uri.equals("ref://foo") || uri.equals("mock://foo") || uri.equals("mock://result") ? 1 : 0) != 0);
        }
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                ((RouteDefinition)this.from("direct:start").routeId("foo").to("ref:foo")).to("mock:result");
            }
        };
    }
}

