/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management;

import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.management.openmbean.TabularData;
import org.apache.camel.ServiceStatus;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.management.ManagementTestSupport;
import org.apache.camel.model.RouteDefinition;

public class ManagedSendProcessorTest
extends ManagementTestSupport {
    public void testManageSendProcessor() throws Exception {
        if (ManagedSendProcessorTest.isPlatform("aix")) {
            return;
        }
        MockEndpoint result = this.getMockEndpoint("mock:result");
        result.expectedMessageCount(1);
        MockEndpoint foo = this.getMockEndpoint("mock:foo");
        foo.expectedMessageCount(0);
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
        MBeanServer mbeanServer = this.getMBeanServer();
        ObjectName on = ObjectName.getInstance("org.apache.camel:context=camel-1,type=processors,name=\"mysend\"");
        String routeId = (String)mbeanServer.getAttribute(on, "RouteId");
        ManagedSendProcessorTest.assertEquals((String)"route1", (String)routeId);
        String camelId = (String)mbeanServer.getAttribute(on, "CamelId");
        ManagedSendProcessorTest.assertEquals((String)"camel-1", (String)camelId);
        String state = (String)mbeanServer.getAttribute(on, "State");
        ManagedSendProcessorTest.assertEquals((String)ServiceStatus.Started.name(), (String)state);
        String destination = (String)mbeanServer.getAttribute(on, "Destination");
        ManagedSendProcessorTest.assertEquals((String)"mock://result", (String)destination);
        String pattern = (String)mbeanServer.getAttribute(on, "MessageExchangePattern");
        ManagedSendProcessorTest.assertNull((Object)pattern);
        TabularData data = (TabularData)mbeanServer.invoke(on, "explain", new Object[]{false}, new String[]{"boolean"});
        ManagedSendProcessorTest.assertNotNull((Object)data);
        ManagedSendProcessorTest.assertEquals((int)2, (int)data.size());
        data = (TabularData)mbeanServer.invoke(on, "explain", new Object[]{true}, new String[]{"boolean"});
        ManagedSendProcessorTest.assertNotNull((Object)data);
        ManagedSendProcessorTest.assertEquals((int)5, (int)data.size());
        String json = (String)mbeanServer.invoke(on, "informationJson", null, null);
        ManagedSendProcessorTest.assertNotNull((Object)json);
        ManagedSendProcessorTest.assertTrue((boolean)json.contains("\"description\": \"Sends the message to an endpoint\""));
        ManagedSendProcessorTest.assertTrue((boolean)json.contains(" \"uri\": { \"kind\": \"attribute\", \"required\": \"false\", \"type\": \"string\", \"javaType\": \"java.lang.String\", \"deprecated\": \"false\", \"value\": \"mock:result\""));
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                ((RouteDefinition)this.from("direct:start").to("mock:result")).id("mysend");
                this.from("direct:foo").to("mock:foo");
            }
        };
    }
}

