/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management;

import java.util.Iterator;
import java.util.Set;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.camel.Expression;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.management.ManagementTestSupport;
import org.apache.camel.model.RouteDefinition;

public class ManagedSetAndRemoveHeaderAndPropertiesTest
extends ManagementTestSupport {
    public void testSetAndRemove() throws Exception {
        if (ManagedSetAndRemoveHeaderAndPropertiesTest.isPlatform("aix")) {
            return;
        }
        this.getMockEndpoint("mock:result").expectedMessageCount(1);
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
        MBeanServer mbeanServer = this.getMBeanServer();
        Set<ObjectName> set = mbeanServer.queryNames(new ObjectName("*:type=processors,*"), null);
        ManagedSetAndRemoveHeaderAndPropertiesTest.assertEquals((int)8, (int)set.size());
        Iterator<ObjectName> it = set.iterator();
        boolean found = false;
        boolean found2 = false;
        boolean found3 = false;
        boolean found4 = false;
        boolean found5 = false;
        boolean found6 = false;
        for (int i = 0; i < 8; ++i) {
            ObjectName on = it.next();
            boolean registered = mbeanServer.isRegistered(on);
            ManagedSetAndRemoveHeaderAndPropertiesTest.assertEquals((String)"Should be registered", (boolean)true, (boolean)registered);
            String id = (String)mbeanServer.getAttribute(on, "ProcessorId");
            this.log.info("id = {}", (Object)id);
            found |= "setFoo".equals(id);
            found2 |= "setBeer".equals(id);
            found3 |= "unsetFoo".equals(id);
            found4 |= "unsetFoos".equals(id);
            found5 |= "unsetBeer".equals(id);
            found6 |= "unsetBeers".equals(id);
        }
        ManagedSetAndRemoveHeaderAndPropertiesTest.assertTrue((String)"Should find setHeader mbean", (boolean)found);
        ManagedSetAndRemoveHeaderAndPropertiesTest.assertTrue((String)"Should find setProperty mbean", (boolean)found2);
        ManagedSetAndRemoveHeaderAndPropertiesTest.assertTrue((String)"Should find removeHeader mbean", (boolean)found3);
        ManagedSetAndRemoveHeaderAndPropertiesTest.assertTrue((String)"Should find removeHeaders mbean", (boolean)found4);
        ManagedSetAndRemoveHeaderAndPropertiesTest.assertTrue((String)"Should find removeProperty mbean", (boolean)found5);
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                ((RouteDefinition)((RouteDefinition)((RouteDefinition)((RouteDefinition)((RouteDefinition)((RouteDefinition)((RouteDefinition)((RouteDefinition)((RouteDefinition)((RouteDefinition)((RouteDefinition)((RouteDefinition)((RouteDefinition)((RouteDefinition)((RouteDefinition)this.from("direct:start").routeId("foo").setHeader("foo", (Expression)this.constant("bar"))).id("setFoo")).setProperty("beer", (Expression)this.constant("yes"))).id("setBeer")).removeHeader("foo")).id("unsetFoo")).removeHeaders("foo")).id("unsetFoos")).removeProperty("beer")).id("unsetBeer")).removeProperties("beer")).id("unsetBeers")).to("log:foo")).id("logFoo")).to("mock:result")).id("mockResult");
            }
        };
    }
}

