/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management;

import java.util.Set;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.camel.Exchange;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.management.ManagementTestSupport;
import org.apache.camel.model.RouteDefinition;

public class ManagedStatisticsTest
extends ManagementTestSupport {
    public void testManageStatistics() throws Exception {
        if (ManagedStatisticsTest.isPlatform("aix")) {
            return;
        }
        MBeanServer mbeanServer = this.getMBeanServer();
        Set<ObjectName> set = mbeanServer.queryNames(new ObjectName("*:type=routes,*"), null);
        ManagedStatisticsTest.assertEquals((int)1, (int)set.size());
        ObjectName on = set.iterator().next();
        Long completed = (Long)mbeanServer.getAttribute(on, "ExchangesCompleted");
        ManagedStatisticsTest.assertEquals((long)0L, (long)completed);
        MockEndpoint result = this.getMockEndpoint("mock:result");
        result.expectedMessageCount(5);
        this.template.sendBody("direct:start", (Object)"A");
        this.template.sendBody("direct:start", (Object)"B");
        this.template.sendBody("direct:start", (Object)"C");
        this.template.sendBody("direct:start", (Object)"D");
        this.template.sendBody("direct:start", (Object)"E");
        this.assertMockEndpointsSatisfied();
        completed = (Long)mbeanServer.getAttribute(on, "ExchangesCompleted");
        ManagedStatisticsTest.assertEquals((long)5L, (long)completed);
        String first = (String)mbeanServer.getAttribute(on, "FirstExchangeCompletedExchangeId");
        ManagedStatisticsTest.assertEquals((String)((Exchange)result.getReceivedExchanges().get(0)).getExchangeId(), (String)first);
        String firstFail = (String)mbeanServer.getAttribute(on, "FirstExchangeFailureExchangeId");
        ManagedStatisticsTest.assertNull((Object)firstFail);
        String last = (String)mbeanServer.getAttribute(on, "LastExchangeCompletedExchangeId");
        ManagedStatisticsTest.assertEquals((String)((Exchange)result.getReceivedExchanges().get(4)).getExchangeId(), (String)last);
        String lastFail = (String)mbeanServer.getAttribute(on, "LastExchangeFailureExchangeId");
        ManagedStatisticsTest.assertNull((Object)lastFail);
        ObjectName foo = ObjectName.getInstance("org.apache.camel:context=camel-1,type=processors,name=\"foo\"");
        completed = (Long)mbeanServer.getAttribute(foo, "ExchangesCompleted");
        ManagedStatisticsTest.assertEquals((long)5L, (long)completed);
        ObjectName mock = ObjectName.getInstance("org.apache.camel:context=camel-1,type=processors,name=\"mock\"");
        completed = (Long)mbeanServer.getAttribute(mock, "ExchangesCompleted");
        ManagedStatisticsTest.assertEquals((long)5L, (long)completed);
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                ((RouteDefinition)((RouteDefinition)((RouteDefinition)((RouteDefinition)((RouteDefinition)this.from("direct:start").to("log:foo")).id("foo")).to("log:bar")).id("bar")).to("mock:result")).id("mock");
            }
        };
    }
}

