/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management;

import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.management.ManagementTestSupport;
import org.apache.camel.model.ThreadsDefinition;

public class ManagedThreadPoolWithIdTest
extends ManagementTestSupport {
    public void testManagedThreadPool() throws Exception {
        if (ManagedThreadPoolWithIdTest.isPlatform("aix")) {
            return;
        }
        MBeanServer mbeanServer = this.getMBeanServer();
        ObjectName on = ObjectName.getInstance("org.apache.camel:context=camel-1,type=threadpools,name=\"myThreads(threads)\"");
        Boolean shutdown = (Boolean)mbeanServer.getAttribute(on, "Shutdown");
        ManagedThreadPoolWithIdTest.assertEquals((boolean)false, (boolean)shutdown);
        Integer corePoolSize = (Integer)mbeanServer.getAttribute(on, "CorePoolSize");
        ManagedThreadPoolWithIdTest.assertEquals((int)15, (int)corePoolSize);
        Integer maxPoolSize = (Integer)mbeanServer.getAttribute(on, "MaximumPoolSize");
        ManagedThreadPoolWithIdTest.assertEquals((int)30, (int)maxPoolSize);
        Integer poolSize = (Integer)mbeanServer.getAttribute(on, "PoolSize");
        ManagedThreadPoolWithIdTest.assertEquals((int)0, (int)poolSize);
        Long keepAlive = (Long)mbeanServer.getAttribute(on, "KeepAliveTime");
        ManagedThreadPoolWithIdTest.assertEquals((int)60, (int)keepAlive.intValue());
        this.getMockEndpoint("mock:result").expectedMessageCount(1);
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
        String id = (String)mbeanServer.getAttribute(on, "Id");
        ManagedThreadPoolWithIdTest.assertEquals((String)"myThreads", (String)id);
        String source = (String)mbeanServer.getAttribute(on, "SourceId");
        ManagedThreadPoolWithIdTest.assertEquals((String)"threads", (String)source);
        String routeId = (String)mbeanServer.getAttribute(on, "RouteId");
        ManagedThreadPoolWithIdTest.assertEquals((String)"myRoute", (String)routeId);
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                ((ThreadsDefinition)this.from("direct:start").routeId("myRoute").threads(15, 30).id("myThreads")).to("mock:result");
            }
        };
    }
}

